/*
 * Decompiled with CFR 0.152.
 */
package uxparser;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class XWriter
extends Writer {
    private static String[] SPACES = new String[50];
    private OutputStream sink;
    private Writer xout;
    private boolean zipped;
    private int numWritten;

    static {
        XWriter.SPACES[0] = "";
        int i = 1;
        while (i < 50) {
            XWriter.SPACES[i] = String.valueOf(SPACES[i - 1]) + " ";
            ++i;
        }
    }

    public XWriter(OutputStream out) throws IOException {
        this.sink = out;
    }

    public XWriter w(Object x) throws IOException {
        this.write(String.valueOf(x));
        return this;
    }

    public final XWriter w(boolean x) throws IOException {
        this.write(String.valueOf(x));
        return this;
    }

    public final XWriter w(char x) throws IOException {
        this.write(x);
        return this;
    }

    public final XWriter w(int x) throws IOException {
        this.write(String.valueOf(x));
        return this;
    }

    public final XWriter w(long x) throws IOException {
        this.write(String.valueOf(x));
        return this;
    }

    public final XWriter w(float x) throws IOException {
        this.write(String.valueOf(x));
        return this;
    }

    public final XWriter w(double x) throws IOException {
        this.write(String.valueOf(x));
        return this;
    }

    public final XWriter nl() throws IOException {
        this.write(10);
        return this;
    }

    public final XWriter indent(int indent) throws IOException {
        this.write(XWriter.getSpaces(indent));
        return this;
    }

    public final XWriter attr(String name, String value) throws IOException {
        this.write(name);
        this.write(61);
        this.write(34);
        this.safe(value);
        this.write(34);
        return this;
    }

    public XWriter prolog() throws IOException {
        this.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        return this;
    }

    public final XWriter safe(String s, boolean escapeWhitespace) throws IOException {
        XWriter.safe(this.xout, s, escapeWhitespace);
        return this;
    }

    public final XWriter safe(String s) throws IOException {
        XWriter.safe(this.xout, s, true);
        return this;
    }

    public final XWriter safe(int c, boolean escapeWhitespace) throws IOException {
        XWriter.safe((Writer)this, c, escapeWhitespace);
        return this;
    }

    public static void safe(Writer out, String s, boolean escapeWhitespace) throws IOException {
        int len = s.length();
        int i = 0;
        while (i < len) {
            XWriter.safe(out, s.charAt(i), escapeWhitespace);
            ++i;
        }
    }

    public static void safe(Writer out, int c, boolean escapeWhitespace) throws IOException {
        if (c < 32 || c > 126 || c == 39 || c == 34) {
            if (!escapeWhitespace) {
                if (c == 10) {
                    out.write(10);
                    return;
                }
                if (c == 13) {
                    out.write(13);
                    return;
                }
                if (c == 9) {
                    out.write(9);
                    return;
                }
            }
            out.write("&#x");
            out.write(Integer.toHexString(c));
            out.write(59);
        } else if (c == 60) {
            out.write("&lt;");
        } else if (c == 62) {
            out.write("&gt;");
        } else if (c == 38) {
            out.write("&amp;");
        } else {
            out.write((char)c);
        }
    }

    public boolean isZipped() {
        return this.zipped;
    }

    public void setZipped(boolean zipped) throws IOException {
        if (this.numWritten != 0) {
            throw new IllegalStateException("Cannot setZipped after data has been written");
        }
        this.zipped = zipped;
    }

    public void write(int c) throws IOException {
        if (this.xout == null) {
            this.initOut();
        }
        ++this.numWritten;
        this.xout.write(c);
    }

    public void write(char[] buf) throws IOException {
        if (this.xout == null) {
            this.initOut();
        }
        this.numWritten += buf.length;
        this.xout.write(buf);
    }

    public void write(char[] buf, int off, int len) throws IOException {
        if (this.xout == null) {
            this.initOut();
        }
        this.numWritten += len;
        this.xout.write(buf, off, len);
    }

    public void write(String str) throws IOException {
        if (this.xout == null) {
            this.initOut();
        }
        this.numWritten += str.length();
        this.xout.write(str);
    }

    public void write(String str, int off, int len) throws IOException {
        if (this.xout == null) {
            this.initOut();
        }
        this.numWritten += len;
        this.xout.write(str, off, len);
    }

    public void flush() throws IOException {
        if (this.xout == null) {
            this.initOut();
        }
        this.xout.flush();
    }

    public void close() throws IOException {
        if (this.xout == null) {
            this.initOut();
        }
        this.xout.close();
    }

    void initOut() throws IOException {
        this.xout = new OutputStreamWriter(this.sink, "UTF8");
    }

    static String getSpaces(int num) {
        try {
            return SPACES[num];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (num < 0) {
                return "";
            }
            int len = SPACES.length;
            StringBuffer buf = new StringBuffer(num);
            int rem = num;
            while (true) {
                if (rem < len) break;
                buf.append(SPACES[len - 1]);
                rem -= len - 1;
            }
            buf.append(SPACES[rem]);
            return buf.toString();
        }
    }
}

