/*
 * Decompiled with CFR 0.152.
 */
package uxparser;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import uxparser.XElem;
import uxparser.XNs;
import uxparser.XText;

public class XParser {
    public static final int EOF = -1;
    public static final int ELEM_START = 1;
    public static final int ELEM_END = 2;
    public static final int TEXT = 3;
    private static final byte[] charMap = new byte[128];
    private static final int CT_SPACE = 1;
    private static final int CT_NAME = 2;
    private static final String[] internCache;
    private InputStreamReader in;
    private int pushback = -1;
    private int line = 1;
    private int col;
    private int type;
    private XText text = new XText();
    private int depth;
    private XElem[] stack = new XElem[256];
    private XNs[][] nsStack = new XNs[256][];
    private XNs defaultNs;
    private XText buf = new XText();
    private XText entityBuf = new XText();
    private String name;
    private String prefix;
    private boolean popStack;
    private boolean emptyElem;

    static {
        int i = 97;
        while (i <= 122) {
            XParser.charMap[i] = 2;
            ++i;
        }
        i = 65;
        while (i <= 90) {
            XParser.charMap[i] = 2;
            ++i;
        }
        i = 48;
        while (i <= 57) {
            XParser.charMap[i] = 2;
            ++i;
        }
        XParser.charMap[45] = 2;
        XParser.charMap[46] = 2;
        XParser.charMap[95] = 2;
        XParser.charMap[10] = 1;
        XParser.charMap[13] = 1;
        XParser.charMap[32] = 1;
        XParser.charMap[9] = 1;
        internCache = new String[128];
        i = 32;
        while (i < 128) {
            XParser.internCache[i] = new String(new char[]{(char)i}).intern();
            ++i;
        }
    }

    public static XParser make(String xml) throws Exception {
        return XParser.make(new ByteArrayInputStream(xml.getBytes("UTF-8")));
    }

    public static XParser make(InputStream in) throws Exception {
        return new XParser(in);
    }

    protected XParser(InputStream in) throws IOException {
        this.in = new InputStreamReader(in, "UTF-8");
    }

    public final XElem parse() throws Exception {
        return this.parse(true);
    }

    public final XElem parse(boolean close) throws Exception {
        if (this.next() != 1) {
            if (close) {
                this.close();
            }
            throw new IllegalArgumentException("Expecting element start");
        }
        return this.parseCurrent(close);
    }

    public final XElem parseCurrent() throws Exception {
        return this.parseCurrent(false);
    }

    public final XElem parseCurrent(boolean close) throws Exception {
        try {
            XElem root;
            int depth = 1;
            XElem cur = root = this.elem().copy();
            while (depth > 0) {
                int type = this.next();
                if (type == 1) {
                    XElem oldCur = cur;
                    cur = this.elem().copy();
                    oldCur.addContent(cur);
                    ++depth;
                    continue;
                }
                if (type == 2) {
                    cur = cur.parent();
                    --depth;
                    continue;
                }
                if (type == 3) {
                    cur.addContent(this.text().copy());
                    continue;
                }
                if (type != -1) continue;
                throw new EOFException();
            }
            XElem xElem = root;
            return xElem;
        }
        finally {
            if (close) {
                this.close();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int next() throws IOException {
        if (this.popStack) {
            this.popStack = false;
            this.pop();
        }
        if (this.emptyElem) {
            this.emptyElem = false;
            this.popStack = true;
            this.type = 2;
            return 2;
        }
        try {
            while (true) {
                int c;
                if ((c = this.read()) == 60) {
                    c = this.read();
                    if (c == 33) {
                        c = this.read();
                        if (c == 45) {
                            c = this.read();
                            if (c != 45) {
                                throw new IllegalArgumentException("Expecting comment");
                            }
                            this.skipComment();
                            continue;
                        }
                        if (c == 91) {
                            this.consume("CDATA[");
                            this.parseCDATA();
                            this.type = 3;
                            return 3;
                        }
                        if (c != 68) {
                            throw new IllegalArgumentException("Unexpected markup");
                        }
                        this.consume("OCTYPE");
                        this.skipDocType();
                        continue;
                    }
                    if (c == 63) {
                        this.skipPI();
                        continue;
                    }
                    if (c == 47) {
                        this.parseElemEnd();
                        this.popStack = true;
                        this.type = 2;
                        return 2;
                    }
                    this.parseElemStart(c);
                    this.type = 1;
                    return 1;
                }
                if (this.parseText(c)) break;
            }
            this.type = 3;
            return 3;
        }
        catch (EOFException e) {
            this.type = -1;
            return -1;
        }
    }

    public void skip() throws IOException {
        this.skip(this.depth);
    }

    public void skip(int toDepth) throws IOException {
        int type;
        do {
            if (this.type != 2 || this.depth != toDepth) continue;
            return;
        } while ((type = this.next()) != -1);
        throw new EOFException();
    }

    public final int type() {
        return this.type;
    }

    public final int depth() {
        return this.depth;
    }

    public final XElem elem() {
        if (this.depth < 1) {
            return null;
        }
        return this.stack[this.depth - 1];
    }

    public final XElem elem(int depth) {
        if (depth < 0 || depth >= this.depth) {
            return null;
        }
        return this.stack[depth];
    }

    public final XText text() {
        if (this.type == 3) {
            return this.text;
        }
        return null;
    }

    public final int line() {
        return this.line;
    }

    public final int column() {
        return this.col;
    }

    public final void close() {
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void parseElemStart(int c) throws IOException, EOFException {
        XElem elem = this.push();
        this.parseQName(c);
        elem.name = this.name;
        elem.line = this.line;
        String prefix = this.prefix;
        boolean resolveAttrNs = false;
        while (true) {
            boolean sp = this.skipSpace();
            c = this.read();
            if (c == 62) break;
            if (c == 47) {
                c = this.read();
                if (c != 62) {
                    throw new IllegalArgumentException("Expecting /> empty element");
                }
                this.emptyElem = true;
                break;
            }
            if (!sp) {
                throw new IllegalArgumentException("Expecting space before attribute");
            }
            resolveAttrNs |= this.parseAttr(c, elem);
        }
        elem.ns = prefix == null ? this.defaultNs : this.prefixToNs(prefix);
        if (resolveAttrNs) {
            int i = 0;
            while (i < elem.attrSize) {
                if (elem.attr[i * 3 + 1] != null) {
                    elem.attr[i * 3 + 1] = this.prefixToNs((String)elem.attr[i * 3 + 1]);
                }
                ++i;
            }
        }
    }

    private void parseElemEnd() throws IOException, EOFException {
        this.parseQName(this.read());
        XNs ns = null;
        ns = this.prefix == null ? this.defaultNs : this.prefixToNs(this.prefix);
        if (this.depth == 0) {
            throw new IllegalArgumentException("Element end without start");
        }
        XElem elem = this.stack[this.depth - 1];
        if (!elem.name.equals(this.name) || elem.ns != ns) {
            throw new IllegalArgumentException("Expecting end of element '" + elem.qname() + "'[" + elem.line + "]");
        }
        this.skipSpace();
        if (this.read() != 62) {
            throw new IllegalArgumentException("Expecting > end of element");
        }
    }

    private boolean parseAttr(int c, XElem elem) throws IOException, EOFException {
        this.parseQName(c);
        String prefix = this.prefix;
        String name = this.name;
        this.skipSpace();
        if (this.read() != 61) {
            throw new IllegalArgumentException("Expecting '='");
        }
        this.skipSpace();
        c = this.read();
        if (c != 34 && c != 39) {
            throw new IllegalArgumentException("Expecting quoted attribute value");
        }
        String value = this.parseString(c);
        if (prefix == null) {
            if (name.equals("xmlns")) {
                this.pushNs(elem, "", value);
            }
        } else if (prefix.equals("xmlns")) {
            this.pushNs(elem, name, value);
            prefix = null;
            name = "xmlns:" + name;
        } else if (prefix.equalsIgnoreCase("xml")) {
            prefix = null;
            name = "xml:" + name;
        }
        elem.addAttrImpl(prefix, name, value);
        return prefix != null;
    }

    private void parseQName(int c) throws IOException, EOFException {
        this.prefix = null;
        this.name = this.parseName(c);
        c = this.read();
        if (c == 58) {
            this.prefix = this.name;
            this.name = this.parseName(this.read());
        } else {
            this.pushback = c;
        }
    }

    private String parseString(int quote) throws IOException, EOFException {
        int c;
        XText buf = this.buf;
        buf.setLength(0);
        while ((c = this.read()) != quote) {
            buf.append(this.toCharData(c));
        }
        return this.bufToString();
    }

    private String parseName(int c) throws IOException, EOFException {
        if (!XParser.isName(c)) {
            throw new IllegalArgumentException("Expected XML name");
        }
        XText buf = this.buf;
        buf.setLength(0);
        buf.append(c);
        while (XParser.isName(c = this.read())) {
            buf.append(c);
        }
        this.pushback = c;
        return this.bufToString();
    }

    private void parseCDATA() throws IOException, EOFException {
        XText text = this.text;
        text.length = 0;
        text.cdata = true;
        int c2 = -1;
        int c1 = -1;
        int c0 = -1;
        while (true) {
            c2 = c1;
            c1 = c0;
            c0 = this.read();
            if (c2 == 93 && c1 == 93 && c0 == 62) {
                text.setLength(text.length - 2);
                return;
            }
            text.append(c0);
        }
    }

    private boolean parseText(int c) throws IOException, EOFException {
        XText text = this.text;
        text.length = 0;
        text.cdata = false;
        text.append(this.toCharData(c));
        boolean gotText = !XParser.isSpace(c);
        while (true) {
            try {
                c = this.read();
            }
            catch (EOFException e) {
                if (gotText) {
                    throw e;
                }
                return false;
            }
            if (c == 60) {
                this.pushback = c;
                return gotText;
            }
            if (!XParser.isSpace(c)) {
                gotText = true;
            }
            text.append(this.toCharData(c));
        }
    }

    private boolean skipSpace() throws IOException, EOFException {
        int c = this.read();
        if (!XParser.isSpace(c)) {
            this.pushback = c;
            return false;
        }
        while (XParser.isSpace(c = this.read())) {
        }
        this.pushback = c;
        return true;
    }

    private void skipComment() throws IllegalArgumentException, IOException, EOFException {
        int c2 = -1;
        int c1 = -1;
        int c0 = -1;
        do {
            c2 = c1;
            c1 = c0;
            c0 = this.read();
        } while (c2 != 45 || c1 != 45);
        if (c0 != 62) {
            throw new IllegalArgumentException("Cannot have -- in middle of comment");
        }
    }

    private void skipPI() throws IOException, EOFException {
        int c1 = -1;
        int c0 = -1;
        do {
            c1 = c0;
            c0 = this.read();
        } while (c1 != 63 || c0 != 62);
    }

    private void skipDocType() throws IOException, EOFException {
        int depth = 1;
        do {
            int c;
            if ((c = this.read()) == 60) {
                ++depth;
            }
            if (c != 62) continue;
            --depth;
        } while (depth != 0);
    }

    private void consume(String s) throws IllegalArgumentException, IOException, EOFException {
        int len = s.length();
        int i = 0;
        while (i < len) {
            if (this.read() != s.charAt(i)) {
                throw new IllegalArgumentException("Expected '" + s + "'");
            }
            ++i;
        }
    }

    private int read() throws IOException, EOFException {
        int c = this.pushback;
        if (c != -1) {
            this.pushback = -1;
            return c;
        }
        c = this.in.read();
        if (c < 0) {
            throw new EOFException();
        }
        if (c == 10) {
            ++this.line;
            this.col = 0;
            return 10;
        }
        if (c == 13) {
            int lookAhead = this.in.read();
            if (lookAhead != 10) {
                this.pushback = lookAhead;
            }
            ++this.line;
            this.col = 0;
            return 10;
        }
        ++this.col;
        return c;
    }

    private int toCharData(int c) throws IllegalArgumentException, IOException, EOFException {
        if (c == 60) {
            throw new IllegalArgumentException("Invalid markup in char data");
        }
        if (c != 38) {
            return c;
        }
        c = this.read();
        if (c == 35) {
            c = this.in.read();
            ++this.col;
            int x = 0;
            int base = 10;
            if (c == 120) {
                base = 16;
            } else {
                x = this.toNum(x, c, base);
            }
            c = this.in.read();
            ++this.col;
            while (c != 59) {
                x = this.toNum(x, c, base);
                c = this.in.read();
                ++this.col;
            }
            return (char)x;
        }
        XText ebuf = this.entityBuf;
        ebuf.setLength(0);
        ebuf.append(c);
        while ((c = this.read()) != 59) {
            ebuf.append(c);
        }
        String entity = ebuf.string().intern();
        if (entity == "lt") {
            return 60;
        }
        if (entity == "gt") {
            return 62;
        }
        if (entity == "amp") {
            return 38;
        }
        if (entity == "quot") {
            return 34;
        }
        if (entity == "apos") {
            return 39;
        }
        throw new IllegalArgumentException("Unsupported entity &" + entity + ";");
    }

    private int toNum(int x, int c, int base) throws IllegalArgumentException {
        x *= base;
        if (48 <= c && c <= 57) {
            return x + (c - 48);
        }
        if (base == 16) {
            if (97 <= c && c <= 102) {
                return x + 10 + (c - 97);
            }
            if (65 <= c && c <= 70) {
                return x + 10 + (c - 65);
            }
        }
        throw new IllegalArgumentException("Expected base " + base + " number");
    }

    private String bufToString() {
        char ch;
        if (this.buf.length == 1 && ' ' <= (ch = this.buf.data[0]) && ch < '\u0080') {
            return internCache[ch];
        }
        return this.buf.string();
    }

    private XNs prefixToNs(String prefix) {
        int i = this.depth - 1;
        while (i >= 0) {
            XNs[] ns = this.nsStack[i];
            if (ns != null) {
                int j = 0;
                while (j < ns.length) {
                    if (ns[j].prefix.equals(prefix)) {
                        return ns[j];
                    }
                    ++j;
                }
            }
            --i;
        }
        throw new IllegalArgumentException("Undeclared namespace prefix '" + prefix + "'");
    }

    private void pushNs(XElem elem, String prefix, String value) {
        XNs[] list;
        XNs ns = new XNs(prefix, value);
        ns.declaringElem = elem;
        if (prefix == "") {
            this.defaultNs = value.equals("") ? null : ns;
        }
        if ((list = this.nsStack[this.depth - 1]) == null) {
            list = new XNs[]{ns};
        } else {
            XNs[] temp = new XNs[list.length + 1];
            System.arraycopy(list, 0, temp, 0, list.length);
            temp[list.length] = ns;
            list = temp;
        }
        this.nsStack[this.depth - 1] = list;
    }

    private void reEvalDefaultNs() {
        this.defaultNs = null;
        int i = this.depth - 1;
        while (i >= 0) {
            XNs[] ns = this.nsStack[i];
            if (ns != null) {
                int j = 0;
                while (j < ns.length) {
                    if (ns[j].isDefault()) {
                        if (!ns[j].uri.equals("")) {
                            this.defaultNs = ns[j];
                        }
                        return;
                    }
                    ++j;
                }
            }
            --i;
        }
    }

    private XElem push() {
        XElem elem = this.stack[this.depth];
        if (elem == null) {
            elem = this.stack[this.depth] = new XElem();
        }
        ++this.depth;
        elem.clearAttr();
        return elem;
    }

    private void pop() {
        --this.depth;
        XNs[] ns = this.nsStack[this.depth];
        if (ns != null) {
            this.nsStack[this.depth] = null;
            this.reEvalDefaultNs();
        }
    }

    static boolean isName(int c) {
        return c < 128 ? (charMap[c] & 2) != 0 : true;
    }

    static boolean isSpace(int c) {
        return c < 128 ? (charMap[c] & 1) != 0 : false;
    }
}

