/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;

public class RecordStoreUtil {
    private static final Object LOCK = new Object();
    private static final String LAST_MAP_INFO = "LastMapInfo";
    private static final String BOOKMARKS = "Bookmarks";
    private static final String NUMBER_OF_BOOKMARKS = "NumOfBookmarks";

    public static void saveLastMapInfo(Bookmark bookmark) throws RecordStoreException, RecordStoreFullException, RecordStoreNotFoundException, IOException {
        RecordStoreUtil.saveByteArray(LAST_MAP_INFO, Bookmark.toByteArray(bookmark));
    }

    public static Bookmark loadLastMapInfo() throws RecordStoreException, RecordStoreFullException, RecordStoreNotFoundException, IOException {
        byte[] b = RecordStoreUtil.loadByteArray(LAST_MAP_INFO);
        return Bookmark.fromByteArray(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveBookmarks(Bookmarks bookmarks) throws RecordStoreException, RecordStoreFullException, RecordStoreNotFoundException, IOException {
        RecordStore recordStore = null;
        RecordStore recordStore2 = null;
        Object object = LOCK;
        synchronized (object) {
            try {
                RecordStore.deleteRecordStore((String)NUMBER_OF_BOOKMARKS);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                RecordStore.deleteRecordStore((String)BOOKMARKS);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                recordStore2 = RecordStore.openRecordStore((String)NUMBER_OF_BOOKMARKS, (boolean)true);
                byte[] b = Integer.toString(bookmarks.size()).getBytes();
                recordStore2.addRecord(b, 0, b.length);
            }
            catch (Exception b) {
                // empty catch block
            }
            try {
                recordStore = RecordStore.openRecordStore((String)BOOKMARKS, (boolean)true);
                int i = 0;
                while (i < bookmarks.size()) {
                    byte[] b = Bookmark.toByteArray(bookmarks.elementAt(i));
                    recordStore.addRecord(b, 0, b.length);
                    ++i;
                }
            }
            finally {
                if (recordStore != null) {
                    recordStore.closeRecordStore();
                }
                if (recordStore2 != null) {
                    recordStore2.closeRecordStore();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bookmarks loadBookmarks() throws RecordStoreException, RecordStoreFullException, RecordStoreNotFoundException, IOException {
        RecordStore recordStore = null;
        RecordStore recordStore2 = null;
        Bookmarks bookmarks = Bookmarks.getInstance();
        int size = 0;
        Object object = LOCK;
        synchronized (object) {
            try {
                recordStore2 = RecordStore.openRecordStore((String)NUMBER_OF_BOOKMARKS, (boolean)false);
                size = Integer.parseInt(new String(recordStore2.getRecord(1))) + 1;
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                recordStore = RecordStore.openRecordStore((String)BOOKMARKS, (boolean)false);
                if (size == 0) {
                    size = recordStore.getNumRecords() + 1;
                }
                int i = 1;
                while (i < size) {
                    Bookmark bookmark = Bookmark.fromByteArray(recordStore.getRecord(i));
                    bookmarks.addElement(bookmark);
                    ++i;
                }
            }
            finally {
                if (recordStore != null) {
                    recordStore.closeRecordStore();
                }
                if (recordStore2 != null) {
                    recordStore2.closeRecordStore();
                }
            }
        }
        return bookmarks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveByteArray(String recordStoreName, byte[] b) throws RecordStoreException, RecordStoreFullException, RecordStoreNotFoundException {
        RecordStore recordStore = null;
        Object object = LOCK;
        synchronized (object) {
            try {
                RecordStore.deleteRecordStore((String)recordStoreName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                recordStore = RecordStore.openRecordStore((String)recordStoreName, (boolean)true);
                recordStore.addRecord(b, 0, b.length);
            }
            finally {
                if (recordStore != null) {
                    recordStore.closeRecordStore();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] loadByteArray(String recordStoreName) throws RecordStoreException, RecordStoreFullException, RecordStoreNotFoundException {
        RecordStore recordStore = null;
        byte[] b = null;
        Object object = LOCK;
        synchronized (object) {
            try {
                recordStore = RecordStore.openRecordStore((String)recordStoreName, (boolean)false);
                b = recordStore.getRecord(1);
            }
            finally {
                if (recordStore != null) {
                    recordStore.closeRecordStore();
                }
            }
        }
        return b;
    }
}

