/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Ticker;

public class MapCanvas
extends Canvas
implements Runnable,
CommandListener {
    private static final Command CMD_ZOOMUP = new Command("up", 1, 3);
    private static final Command CMD_ZOOMDOWN = new Command("down", 1, 3);
    private static final Command CMD_ADD_BOOKMARK = new Command("\u30d6\u30c3\u30af\u30de\u30fc\u30af\u306b\u8ffd\u52a0\u3059\u308b", 1, 5);
    private static final Command CMD_BOOKMARKS_LIST = new Command("\u30d6\u30c3\u30af\u30de\u30fc\u30af\u30ea\u30b9\u30c8\u3092\u898b\u308b", 1, 5);
    private static final Command CMD_SEARCH = new Command("\u691c\u7d22", 1, 5);
    private static final int CONNECTION_FAILED = 0;
    private static final int CONNECTION_OK = 1;
    private int canvasX;
    private int canvasY;
    private Vector imageInfos = new Vector();
    private int height;
    private int width;
    private int mapX;
    private int mapY;
    private int mapZoom;
    private int lastRelativeX;
    private int lastRelativeY;
    private boolean doDisplayInfo;
    private Font smallFont = Font.getFont((int)0, (int)0, (int)8);
    private static MapCanvas canvas = new MapCanvas();

    public static MapCanvas getInstance(int x, int y, int zoom) {
        canvas.setMapX(x);
        canvas.setMapY(y);
        canvas.setMapZoom(zoom);
        canvas.loadInitialImage();
        return canvas;
    }

    private MapCanvas() {
        this.setCommandListener(this);
        this.height = this.getHeight();
        this.width = this.getWidth();
    }

    protected void keyPressed(int keyCode) {
        int relativeX = -this.canvasX / 256;
        int relativeY = -this.canvasY / 256;
        switch (this.getGameAction(keyCode)) {
            case 1: {
                this.canvasY += 30;
                relativeX = -this.canvasX / 256;
                relativeY = -(this.canvasY + 70) / 256;
                break;
            }
            case 6: {
                this.canvasY -= 30;
                relativeX = -this.canvasX / 256;
                relativeY = -(this.canvasY - 70) / 256;
                break;
            }
            case 2: {
                this.canvasX += 30;
                relativeX = -(this.canvasX + 70) / 256;
                relativeY = -this.canvasY / 256;
                break;
            }
            case 5: {
                this.canvasX -= 30;
                relativeX = -(this.canvasX - 70) / 256;
                relativeY = -this.canvasY / 256;
                break;
            }
            default: {
                switch (keyCode) {
                    case 49: {
                        this.processZoomDown();
                        return;
                    }
                    case 51: {
                        this.processZoomUp();
                        return;
                    }
                    case 53: {
                        this.doDisplayInfo = !this.doDisplayInfo;
                        this.repaint();
                        return;
                    }
                }
            }
        }
        boolean flag = false;
        Enumeration e = this.imageInfos.elements();
        while (e.hasMoreElements()) {
            ImageInfo info = (ImageInfo)e.nextElement();
            if (info.getRelativeX() != relativeX || info.getRelativeY() != relativeY) continue;
            flag = true;
            break;
        }
        if (!flag) {
            System.err.println("canvasX: " + this.canvasX);
            System.err.println("canvasY: " + this.canvasY);
            System.err.println("relativeX: " + relativeX);
            System.err.println("relativeY: " + relativeY);
            this.lastRelativeX = relativeX;
            this.lastRelativeY = relativeY;
            new Thread(this).start();
        } else {
            relativeX = -this.canvasX / 256;
            relativeY = -this.canvasY / 256;
            try {
                RecordStoreUtil.saveLastMapInfo(new Bookmark(this.mapX + relativeX, this.mapY + relativeY, this.getMapZoom()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.repaint();
    }

    private int getImageViaHttp(ImageInfo imageInfo) throws IOException {
        try {
            byte[] buffer = HttpUtil.getBytesViaHttp(imageInfo.getImageUrl());
            if (buffer != null) {
                imageInfo.setImage(buffer);
                this.imageInfos.addElement(imageInfo);
                return 1;
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        return 0;
    }

    protected void paint(Graphics g) {
        g.setColor(255, 255, 255);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        Enumeration e = this.imageInfos.elements();
        while (e.hasMoreElements()) {
            ImageInfo info = (ImageInfo)e.nextElement();
            try {
                if (info.getImage() == null) continue;
                g.drawImage(info.getImage(), info.getRelativeX() * 256 + this.canvasX + this.width / 2, info.getRelativeY() * 256 + this.canvasY + this.height / 2, 3);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (this.doDisplayInfo) {
            g.setColor(0);
            g.setFont(this.smallFont);
            g.drawString("x=" + this.getCurrentMapX() + " y=" + this.getCurrentMapY() + " zoom=" + this.getMapZoom(), 0, 0, 20);
        }
    }

    public void run() {
        this.setTicker(new Ticker("\u5730\u56f3\u30c7\u30fc\u30bf\u8aad\u307f\u8fbc\u307f\u4e2d"));
        int rc = 0;
        try {
            ImageInfo imageInfo = new ImageInfo(this.getCurrentMapX(), this.getCurrentMapY(), this.mapZoom, this.lastRelativeX, this.lastRelativeY);
            rc = this.getImageViaHttp(imageInfo);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (rc == 1) {
            this.repaint();
            try {
                RecordStoreUtil.saveLastMapInfo(new Bookmark(this.getCurrentMapX(), this.getCurrentMapY(), this.getMapZoom()));
            }
            catch (Exception e) {
                Alert alert = new Alert("RecordStore\u3078\u306e\u66f8\u304d\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e.toString(), null, null);
                MapMIDlet.getDisplay().setCurrent((Displayable)alert);
            }
        } else if (rc == 0) {
            Alert alert = new Alert("\u5730\u56f3\u30c7\u30fc\u30bf\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            MapMIDlet.getDisplay().setCurrent((Displayable)alert);
        }
        this.setTicker(null);
    }

    public int getMapZoom() {
        return this.mapZoom;
    }

    public void setMapZoom(int mapZoom) {
        this.mapZoom = mapZoom;
    }

    public int getCurrentMapX() {
        return this.mapX + this.lastRelativeX;
    }

    public int getCurrentMapY() {
        return this.mapY + this.lastRelativeY;
    }

    public void loadInitialImage() {
        this.imageInfos.setSize(0);
        this.canvasX = 0;
        this.canvasY = 0;
        this.lastRelativeX = 0;
        this.lastRelativeY = 0;
        this.setCommand();
        new Thread(this).start();
    }

    public void setMapX(int mapX) {
        this.mapX = mapX;
    }

    public void setMapY(int mapY) {
        this.mapY = mapY;
    }

    private void setCommand() {
        this.addCommand(CMD_ZOOMUP);
        this.addCommand(CMD_ZOOMDOWN);
        this.addCommand(CMD_ADD_BOOKMARK);
        this.addCommand(CMD_BOOKMARKS_LIST);
        this.addCommand(CMD_SEARCH);
        if (this.getMapZoom() < 1) {
            this.removeCommand(CMD_ZOOMUP);
        } else if (this.getMapZoom() > 16) {
            this.removeCommand(CMD_ZOOMDOWN);
        }
    }

    public void commandAction(Command command, Displayable arg1) {
        if (command == CMD_ZOOMUP) {
            this.processZoomUp();
        } else if (command == CMD_ZOOMDOWN) {
            this.processZoomDown();
        } else if (command == CMD_ADD_BOOKMARK) {
            Bookmark bookmark = new Bookmark(this.getCurrentMapX(), this.getCurrentMapY(), this.getMapZoom());
            BookmarkRegisterForm bookmarkRegisterForm = BookmarkRegisterForm.getInstance(bookmark, (Displayable)this);
            MapMIDlet.getDisplay().setCurrent((Displayable)bookmarkRegisterForm);
        } else if (command == CMD_BOOKMARKS_LIST) {
            MapMIDlet.getDisplay().setCurrent((Displayable)BookmarksList.getInstance((Displayable)this));
        } else if (command == CMD_SEARCH) {
            MapMIDlet.getDisplay().setCurrent((Displayable)SearchForm.getInstance((Displayable)this));
        }
    }

    private void processZoomDown() {
        if (this.getMapZoom() < 16) {
            this.setMapZoom(this.getMapZoom() + 1);
            this.setMapX(this.getCurrentMapX() / 2);
            this.setMapY(this.getCurrentMapY() / 2);
        }
        this.loadInitialImage();
    }

    private void processZoomUp() {
        if (this.getMapZoom() > 0) {
            this.setMapZoom(this.getMapZoom() - 1);
            this.setMapX(this.getCurrentMapX() * 2);
            this.setMapY(this.getCurrentMapY() * 2);
        }
        this.loadInitialImage();
    }
}

