/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import uxparser.XParser;

public class GeocoodingInfo {
    private String address;
    private double lat;
    private double lng;
    private Vector choices = new Vector();
    private String errorCode;
    private int status;
    public static final int STATUS_SUCCESS = 0;
    public static final int STATUS_MULTI = 1;
    public static final int STATUS_FAILURE = 2;

    private static GeocoodingInfo getInstance() {
        return new GeocoodingInfo();
    }

    private static String urlEncode(String str) {
        StringBuffer buffer = new StringBuffer();
        try {
            byte[] b = str.getBytes("UTF-8");
            int i = 0;
            while (i < b.length) {
                String hexString = Integer.toHexString(b[i]);
                hexString = hexString.substring(hexString.length() - 2);
                buffer.append("%" + hexString);
                ++i;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return buffer.toString();
    }

    public static GeocoodingInfo getGeocordingInfo(String str) {
        String url = "http://www.geocoding.jp/api/?q=" + GeocoodingInfo.urlEncode(str);
        try {
            byte[] b = HttpUtil.getBytesViaHttp(url);
            return GeocoodingInfo.parseGeocoodingResponse(new ByteArrayInputStream(b));
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static GeocoodingInfo parseGeocoodingResponse(InputStream in) {
        GeocoodingInfo info = GeocoodingInfo.getInstance();
        XParser parser = null;
        try {
            try {
                int code;
                parser = XParser.make(in);
                block11: while ((code = parser.next()) != -1) {
                    switch (code) {
                        case 1: {
                            if (parser.elem().name().equals("error")) {
                                info.setStatus(2);
                                break;
                            }
                            if (parser.elem().name().equals("coordinate")) {
                                info.setStatus(0);
                                break;
                            }
                            if (!parser.elem().name().equals("choices")) continue block11;
                            info.setStatus(1);
                            break;
                        }
                        case 3: {
                            if (parser.elem().name().equals("error")) {
                                info.setErrorCode(parser.text().string());
                                GeocoodingInfo geocoodingInfo = info;
                                return geocoodingInfo;
                            }
                            if (parser.elem().name().equals("lat")) {
                                info.setLat(Double.parseDouble(parser.text().string()));
                                break;
                            }
                            if (parser.elem().name().equals("lng")) {
                                info.setLng(Double.parseDouble(parser.text().string()));
                                break;
                            }
                            if (parser.elem().name().equals("choice")) {
                                info.addChoice(parser.text().string());
                                break;
                            }
                            if (!parser.elem().name().equals("address")) continue block11;
                            info.setAddress(parser.text().string());
                            break;
                        }
                    }
                }
                return info;
            }
            finally {
                if (parser != null) {
                    parser.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return info;
        }
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Vector getChoices() {
        return this.choices;
    }

    public void addChoice(String choice) {
        this.choices.addElement(choice);
    }

    public double getLat() {
        return this.lat;
    }

    public void setLat(double lat) {
        this.lat = lat;
    }

    public double getLng() {
        return this.lng;
    }

    public void setLng(double lng) {
        this.lng = lng;
    }

    public int getStatus() {
        return this.status;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getMapX() {
        return (int)(65490.1380675011 + 364.742571409815 * this.lng + -0.00234809008218882 * this.lng * this.lng);
    }

    public int getMapY() {
        return (int)(65075.8820342895 + -306.840892815428 * this.lat + -2.74975444254558 * this.lat * this.lat + 0.0438525983751735 * this.lat * this.lat * this.lat + -6.206473704376E-4 * this.lat * this.lat * this.lat * this.lat);
    }
}

