/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Bookmark {
    private String name;
    private int x;
    private int y;
    private int zoom;
    private static final int BOOKMARK_FORMAT_VERSION = 0;

    public Bookmark(String name, int x, int y, int zoom) {
        this.name = name;
        this.x = x;
        this.y = y;
        this.zoom = zoom;
    }

    public Bookmark(int x, int y, int zoom) {
        this("x=" + x + ", y=" + y + ", zoom=" + zoom, x, y, zoom);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getZoom() {
        return this.zoom;
    }

    public void setZoom(int zoom) {
        this.zoom = zoom;
    }

    public static byte[] toByteArray(Bookmark bookmark) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        byte[] b = null;
        try {
            dos.writeInt(0);
            dos.writeUTF(bookmark.getName());
            dos.writeInt(bookmark.getX());
            dos.writeInt(bookmark.getY());
            dos.writeInt(bookmark.getZoom());
            b = baos.toByteArray();
        }
        finally {
            dos.close();
        }
        return b;
    }

    public static Bookmark fromByteArray(byte[] b) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(b);
        DataInputStream dis = new DataInputStream(bais);
        Bookmark bookmark = null;
        try {
            int version = dis.readInt();
            if (version > 0) {
                throw new IOException("\u30d0\u30fc\u30b8\u30e7\u30f3\u304c\u7570\u306a\u308a\u307e\u3059");
            }
            String name = dis.readUTF();
            int x = dis.readInt();
            int y = dis.readInt();
            int zoom = dis.readInt();
            bookmark = new Bookmark(name, x, y, zoom);
        }
        finally {
            dis.close();
        }
        return bookmark;
    }
}

