/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;

public class SettingsForm
extends Form
implements CommandListener {
    private ChoiceGroup rubyFontChoiceGroup;
    private ChoiceGroup plainFontChoiceGroup;
    private String[] rubyFontSizeArray = new String[]{"SMALL", "MEDIUM", "LARGE", "\u306a\u3057"};
    private String[] fontSizeArray = new String[]{"SMALL", "MEDIUM", "LARGE"};
    private String[] yokotateSizeArray = new String[]{"\u6a2a\u66f8\u304d", "\u7e26\u66f8\u304d"};
    private Displayable previousDisplayable;
    private TextField stepField;
    private TextField fastStepField;
    private TextField textColorRedField;
    private TextField textColorGreenField;
    private TextField textColorBlueField;
    private TextField backgroundColorRedField;
    private TextField backgroundColorGreenField;
    private TextField backgroundColorBlueField;
    private ChoiceGroup isTategakiChoiceGroup;
    private TextField widthBetweenPlainsField;
    private TextField widthBetweenPlainAndRubyField;
    private TextField widthBetweenRubyAndPlainField;
    private final Command CMD_OK = new Command("OK", 4, 1);
    private final Command CMD_CANCEL = new Command("CANCEL", 3, 1);
    private Display display;
    private Settings settings;
    private static SettingsForm settingsForm = new SettingsForm();

    public static SettingsForm getInstance(Displayable displayable) {
        SettingsForm.settingsForm.previousDisplayable = displayable;
        SettingsForm.settingsForm.settings = Settings.getInstance();
        SettingsForm.settingsForm.display = AozoraMIDlet.getDisplay();
        settingsForm.init();
        return settingsForm;
    }

    private void setRubyFontChoiceGroup(ChoiceGroup choiceGroup, int selected) {
        boolean[] isSelected = new boolean[4];
        if (selected == 8) {
            isSelected[0] = true;
        } else if (selected == 0) {
            isSelected[1] = true;
        } else if (selected == 16) {
            isSelected[2] = true;
        } else {
            isSelected[3] = true;
        }
        choiceGroup.setSelectedFlags(isSelected);
        choiceGroup.setFont(0, Font.getFont((int)0, (int)0, (int)8));
        choiceGroup.setFont(1, Font.getFont((int)0, (int)0, (int)0));
        choiceGroup.setFont(2, Font.getFont((int)0, (int)0, (int)16));
        choiceGroup.setFont(3, Font.getFont((int)0, (int)0, (int)8));
    }

    private void setFontChoiceGroup(ChoiceGroup choiceGroup, int selected) {
        boolean[] isSelected = new boolean[3];
        if (selected == 8) {
            isSelected[0] = true;
        } else if (selected == 0) {
            isSelected[1] = true;
        } else if (selected == 16) {
            isSelected[2] = true;
        }
        choiceGroup.setSelectedFlags(isSelected);
        choiceGroup.setFont(0, Font.getFont((int)0, (int)0, (int)8));
        choiceGroup.setFont(1, Font.getFont((int)0, (int)0, (int)0));
        choiceGroup.setFont(2, Font.getFont((int)0, (int)0, (int)16));
    }

    private void init() {
        this.setRubyFontChoiceGroup(this.rubyFontChoiceGroup, this.settings.getRubyTextSize());
        this.setFontChoiceGroup(this.plainFontChoiceGroup, this.settings.getPlainTextSize());
        this.stepField.setString(Integer.toString(this.settings.getStep()));
        this.fastStepField.setString(Integer.toString(this.settings.getFastStep()));
        this.textColorRedField.setString(Integer.toString(this.settings.getTextColor() >> 16));
        this.textColorGreenField.setString(Integer.toString((this.settings.getTextColor() >> 8) % 256));
        this.textColorBlueField.setString(Integer.toString(this.settings.getTextColor() % 256));
        this.backgroundColorRedField.setString(Integer.toString(this.settings.getBackgroundColor() >> 16));
        this.backgroundColorGreenField.setString(Integer.toString((this.settings.getBackgroundColor() >> 8) % 256));
        this.backgroundColorBlueField.setString(Integer.toString(this.settings.getBackgroundColor() % 256));
        boolean[] isSelected = new boolean[2];
        if (this.settings.isTategaki()) {
            isSelected[1] = true;
        } else {
            isSelected[0] = true;
        }
        this.widthBetweenPlainsField.setString(Integer.toString(this.settings.getWidthBetweenPlains()));
        this.widthBetweenPlainAndRubyField.setString(Integer.toString(this.settings.getWidthBetweenPlainAndRuby()));
        this.widthBetweenRubyAndPlainField.setString(Integer.toString(this.settings.getWidthBetweenRubyAndPlain()));
    }

    private SettingsForm() {
        super("\u8a2d\u5b9a");
        this.rubyFontChoiceGroup = new ChoiceGroup("\u30eb\u30d3\u306e\u30d5\u30a9\u30f3\u30c8\u30b5\u30a4\u30ba", 4, this.rubyFontSizeArray, null);
        this.plainFontChoiceGroup = new ChoiceGroup("\u672c\u6587\u306e\u30d5\u30a9\u30f3\u30c8\u30b5\u30a4\u30ba", 4, this.fontSizeArray, null);
        this.stepField = new TextField("\u4e00\u5ea6\u306b\u79fb\u52d5\u3059\u308b\u884c\u6570", null, 2, 2);
        this.fastStepField = new TextField("\u30ad\u30fc\u9577\u62bc\u3057\u6642\u306b\u4e00\u5ea6\u306b\u79fb\u52d5\u3059\u308b\u884c\u6570", null, 2, 2);
        this.textColorRedField = new TextField("\u30c6\u30ad\u30b9\u30c8\u306e\u8272\u306e\u8d64\u6210\u5206(0-255)", null, 3, 2);
        this.textColorGreenField = new TextField("\u30c6\u30ad\u30b9\u30c8\u306e\u8272\u306e\u7dd1\u6210\u5206(0-255)", null, 3, 2);
        this.textColorBlueField = new TextField("\u30c6\u30ad\u30b9\u30c8\u306e\u8272\u306e\u9752\u6210\u5206(0-255)", null, 3, 2);
        this.backgroundColorRedField = new TextField("\u80cc\u666f\u306e\u8272\u306e\u8d64\u6210\u5206(0-255)", null, 3, 2);
        this.backgroundColorGreenField = new TextField("\u80cc\u666f\u306e\u8272\u306e\u7dd1\u6210\u5206(0-255)", null, 3, 2);
        this.backgroundColorBlueField = new TextField("\u80cc\u666f\u306e\u8272\u306e\u9752\u6210\u5206(0-255)", null, 3, 2);
        this.isTategakiChoiceGroup = new ChoiceGroup("\u8aad\u8fbc\u6642\u306b\u6a2a\u66f8/\u7e26\u66f8", 4, this.yokotateSizeArray, null);
        this.widthBetweenPlainsField = new TextField("\u30eb\u30d3\u306a\u3057\u6642\u306e\u884c\u9593\u306e\u30d4\u30af\u30bb\u30eb", null, 2, 2);
        this.widthBetweenPlainAndRubyField = new TextField("\u30eb\u30d3\u3068\u4e0a/\u53f3\u306e\u6587\u306e\u9593\u306e\u30d4\u30af\u30bb\u30eb", null, 2, 2);
        this.widthBetweenRubyAndPlainField = new TextField("\u30eb\u30d3\u3068\u4e0b/\u5de6\u306e\u6587\u306e\u9593\u306e\u30d4\u30af\u30bb\u30eb", null, 2, 2);
        this.append((Item)this.rubyFontChoiceGroup);
        this.append((Item)this.plainFontChoiceGroup);
        this.append((Item)this.stepField);
        this.append((Item)this.fastStepField);
        this.append((Item)this.textColorRedField);
        this.append((Item)this.textColorGreenField);
        this.append((Item)this.textColorBlueField);
        this.append((Item)this.backgroundColorRedField);
        this.append((Item)this.backgroundColorGreenField);
        this.append((Item)this.backgroundColorBlueField);
        this.append((Item)this.isTategakiChoiceGroup);
        this.append((Item)this.widthBetweenPlainsField);
        this.append((Item)this.widthBetweenPlainAndRubyField);
        this.append((Item)this.widthBetweenRubyAndPlainField);
        this.addCommand(this.CMD_OK);
        this.addCommand(this.CMD_CANCEL);
        this.setCommandListener(this);
    }

    public int getFontSize(int index) {
        if (index == 0) {
            return 8;
        }
        if (index == 1) {
            return 0;
        }
        if (index == 2) {
            return 16;
        }
        return 32;
    }

    private int getRegularizdColorComponent(int color) {
        if (color < 0) {
            color = 0;
        } else if (color > 255) {
            color = 255;
        }
        return color;
    }

    private int getColor(int red, int green, int blue) {
        return (this.getRegularizdColorComponent(red) << 16) + (this.getRegularizdColorComponent(green) << 8) + this.getRegularizdColorComponent(blue);
    }

    private int getRegulizedStep(int step) {
        if (step <= 0) {
            step = 1;
        }
        return step;
    }

    private int getRegulizedWidth(int width) {
        if (width < 0) {
            width = 0;
        }
        return width;
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.CMD_OK) {
            try {
                int index = this.rubyFontChoiceGroup.getSelectedIndex();
                this.settings.setRubyTextSize(this.getFontSize(index));
                index = this.plainFontChoiceGroup.getSelectedIndex();
                this.settings.setPlainTextSize(this.getFontSize(index));
                this.settings.setStep(this.getRegulizedStep(Integer.parseInt(this.stepField.getString())));
                this.settings.setFastStep(this.getRegulizedStep(Integer.parseInt(this.fastStepField.getString())));
                this.settings.setTextColor(this.getColor(Integer.parseInt(this.textColorRedField.getString()), Integer.parseInt(this.textColorGreenField.getString()), Integer.parseInt(this.textColorBlueField.getString())));
                this.settings.setBackgroundColor(this.getColor(Integer.parseInt(this.backgroundColorRedField.getString()), Integer.parseInt(this.backgroundColorGreenField.getString()), Integer.parseInt(this.backgroundColorBlueField.getString())));
                if (this.isTategakiChoiceGroup.getSelectedIndex() == 0) {
                    this.settings.setTategaki(false);
                } else {
                    this.settings.setTategaki(true);
                }
                this.settings.setWidthBetweenPlains(this.getRegulizedWidth(Integer.parseInt(this.widthBetweenPlainsField.getString())));
                this.settings.setWidthBetweenPlainAndRuby(this.getRegulizedWidth(Integer.parseInt(this.widthBetweenPlainAndRubyField.getString())));
                this.settings.setWidthBetweenRubyAndPlain(this.getRegulizedWidth(Integer.parseInt(this.widthBetweenRubyAndPlainField.getString())));
                RecordStoreUtil.saveSettings(this.settings);
            }
            catch (NumberFormatException e) {
                Alert alert = new Alert("\u6570\u5b57\u304c\u6b63\u3057\u304f\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093", "\u6570\u5b57\u304c\u6b63\u3057\u304f\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093", null, null);
                this.display.setCurrent((Displayable)alert);
            }
            catch (Exception e) {
                Alert alert = new Alert("\u8a2d\u5b9a\u306e\u4fdd\u5b58\u306b\u5931\u6557\u3057\u307e\u3057\u305f", "\u8a2d\u5b9a\u306e\u4fdd\u5b58\u306b\u5931\u6557\u3057\u307e\u3057\u305f", null, null);
                this.display.setCurrent((Displayable)alert);
            }
        }
        if (this.previousDisplayable instanceof AozoraCanvas) {
            ((AozoraCanvas)this.previousDisplayable).finalizeSettei(true);
        }
        this.display.setCurrent(this.previousDisplayable);
    }
}

