/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Settings {
    private static final int SETTINGS_FORMAT_VERSION = 1;
    private static final int SETTINGS_FORMAT_VERSION_0 = 0;
    private int plainTextSize;
    private int rubyTextSize;
    private int step;
    private int fastStep;
    private int textColor;
    private int backgroundColor;
    private boolean isTategaki;
    private int widthBetweenPlains;
    private int widthBetweenPlainAndRuby;
    private int widthBetweenRubyAndPlain;
    public static final int FONT_SIZE_NONE = 32;
    private static Settings settings;
    private static final Object LOCK;

    static {
        LOCK = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Settings getInstance() {
        Object object = LOCK;
        synchronized (object) {
            if (settings != null) {
                return settings;
            }
            if (settings == null) {
                try {
                    settings = RecordStoreUtil.loadSettings();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (settings == null) {
                settings = new Settings();
            }
            return settings;
        }
    }

    private Settings() {
        this.plainTextSize = 0;
        this.rubyTextSize = 8;
        this.step = 3;
        this.fastStep = 6;
        this.textColor = 0;
        this.backgroundColor = 65535;
        this.isTategaki = false;
        this.widthBetweenPlains = 5;
        this.widthBetweenPlainAndRuby = 0;
        this.widthBetweenRubyAndPlain = 0;
    }

    public Settings(int plainTextSize, int rubyTextSize, int step, int fastStep, int textColor, int backgroundColor, boolean isTategaki, int widthBetweenPlains, int widthBetweenPlainAndRuby, int widthBetweenRubyAndPlain) {
        this.plainTextSize = plainTextSize;
        this.rubyTextSize = rubyTextSize;
        this.step = step;
        this.fastStep = fastStep;
        this.textColor = textColor;
        this.backgroundColor = backgroundColor;
        this.isTategaki = isTategaki;
        this.widthBetweenPlains = widthBetweenPlains;
        this.widthBetweenPlainAndRuby = widthBetweenPlainAndRuby;
        this.widthBetweenRubyAndPlain = widthBetweenRubyAndPlain;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public int getFastStep() {
        return this.fastStep;
    }

    public void setFastStep(int fastStep) {
        this.fastStep = fastStep;
    }

    public int getPlainTextSize() {
        return this.plainTextSize;
    }

    public void setPlainTextSize(int plainTextSize) {
        this.plainTextSize = plainTextSize;
    }

    public int getRubyTextSize() {
        return this.rubyTextSize;
    }

    public void setRubyTextSize(int rubyTextSize) {
        this.rubyTextSize = rubyTextSize;
    }

    public int getStep() {
        return this.step;
    }

    public void setStep(int step) {
        this.step = step;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
    }

    public boolean isTategaki() {
        return this.isTategaki;
    }

    public void setTategaki(boolean isTategaki) {
        this.isTategaki = isTategaki;
    }

    public static byte[] toByteArray(Settings settings) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        byte[] b = null;
        try {
            dos.writeInt(1);
            dos.writeInt(settings.getPlainTextSize());
            dos.writeInt(settings.getRubyTextSize());
            dos.writeInt(settings.getStep());
            dos.writeInt(settings.getFastStep());
            dos.writeInt(settings.getTextColor());
            dos.writeInt(settings.getBackgroundColor());
            dos.writeBoolean(settings.isTategaki());
            dos.writeInt(settings.getWidthBetweenPlains());
            dos.writeInt(settings.getWidthBetweenPlainAndRuby());
            dos.writeInt(settings.getWidthBetweenRubyAndPlain());
            b = baos.toByteArray();
        }
        finally {
            dos.close();
        }
        return b;
    }

    public static Settings fromByteArray(byte[] b) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(b);
        DataInputStream dis = new DataInputStream(bais);
        Settings settings = null;
        try {
            int widthBetweenRubyAndPlain;
            int widthBetweenPlainAndRuby;
            int widthBetweenPlains;
            int version = dis.readInt();
            if (version > 1) {
                throw new IOException("\u30d0\u30fc\u30b8\u30e7\u30f3\u304c\u7570\u306a\u308a\u307e\u3059");
            }
            int plainTextSize = dis.readInt();
            int rubyTextSize = dis.readInt();
            int step = dis.readInt();
            int fastStep = dis.readInt();
            int textColor = dis.readInt();
            int backgroundColor = dis.readInt();
            boolean isTategaki = dis.readBoolean();
            if (version != 0) {
                widthBetweenPlains = dis.readInt();
                widthBetweenPlainAndRuby = dis.readInt();
                widthBetweenRubyAndPlain = dis.readInt();
            } else {
                widthBetweenPlains = 1;
                widthBetweenPlainAndRuby = 0;
                widthBetweenRubyAndPlain = 0;
            }
            settings = new Settings(plainTextSize, rubyTextSize, step, fastStep, textColor, backgroundColor, isTategaki, widthBetweenPlains, widthBetweenPlainAndRuby, widthBetweenRubyAndPlain);
        }
        finally {
            dis.close();
        }
        return settings;
    }

    public int getWidthBetweenPlainAndRuby() {
        return this.widthBetweenPlainAndRuby;
    }

    public void setWidthBetweenPlainAndRuby(int widthBetweenPlainAndRuby) {
        this.widthBetweenPlainAndRuby = widthBetweenPlainAndRuby;
    }

    public int getWidthBetweenPlains() {
        return this.widthBetweenPlains;
    }

    public void setWidthBetweenPlains(int widthBetweenPlains) {
        this.widthBetweenPlains = widthBetweenPlains;
    }

    public int getWidthBetweenRubyAndPlain() {
        return this.widthBetweenRubyAndPlain;
    }

    public void setWidthBetweenRubyAndPlain(int widthBetweenRubyAndPlain) {
        this.widthBetweenRubyAndPlain = widthBetweenRubyAndPlain;
    }
}

