/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;

public class RecordStoreUtil {
    private static final Object LOCK = new Object();
    private static final String LAST_FILE_INFO = "LastFileInfo";
    private static final String SETTINGS = "Settings";
    private static final String BOOKMARKS = "Bookmarks";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveBookmarks(Bookmarks bookmarks) throws RecordStoreException, RecordStoreFullException, RecordStoreNotFoundException, IOException {
        RecordStore recordStore = null;
        Object object = LOCK;
        synchronized (object) {
            try {
                RecordStore.deleteRecordStore((String)BOOKMARKS);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                recordStore = RecordStore.openRecordStore((String)BOOKMARKS, (boolean)true);
                int i = 0;
                while (i < bookmarks.size()) {
                    byte[] b = Bookmark.toByteArray(bookmarks.elementAt(i));
                    recordStore.addRecord(b, 0, b.length);
                    ++i;
                }
            }
            finally {
                if (recordStore != null) {
                    recordStore.closeRecordStore();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bookmarks loadBookmarks() throws RecordStoreException, RecordStoreFullException, RecordStoreNotFoundException, IOException {
        RecordStore recordStore = null;
        Bookmarks bookmarks = Bookmarks.getInstance();
        Object object = LOCK;
        synchronized (object) {
            try {
                recordStore = RecordStore.openRecordStore((String)BOOKMARKS, (boolean)false);
                int size = recordStore.getNumRecords() + 1;
                int i = 1;
                while (i < size) {
                    Bookmark bookmark = Bookmark.fromByteArray(recordStore.getRecord(i));
                    bookmarks.addElement(bookmark);
                    ++i;
                }
            }
            finally {
                if (recordStore != null) {
                    recordStore.closeRecordStore();
                }
            }
        }
        return bookmarks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveByteArray(String recordStoreName, byte[] b) throws RecordStoreException, RecordStoreFullException, RecordStoreNotFoundException {
        RecordStore recordStore = null;
        Object object = LOCK;
        synchronized (object) {
            try {
                RecordStore.deleteRecordStore((String)recordStoreName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                recordStore = RecordStore.openRecordStore((String)recordStoreName, (boolean)true);
                recordStore.addRecord(b, 0, b.length);
            }
            finally {
                if (recordStore != null) {
                    recordStore.closeRecordStore();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] loadByteArray(String recordStoreName) throws RecordStoreException, RecordStoreFullException, RecordStoreNotFoundException {
        RecordStore recordStore = null;
        byte[] b = null;
        Object object = LOCK;
        synchronized (object) {
            try {
                recordStore = RecordStore.openRecordStore((String)recordStoreName, (boolean)false);
                b = recordStore.getRecord(1);
            }
            finally {
                if (recordStore != null) {
                    recordStore.closeRecordStore();
                }
            }
        }
        return b;
    }

    public static void saveCurrentFileInfo(FileInfo fileInfo) throws RecordStoreException, RecordStoreFullException, RecordStoreNotFoundException {
        byte[] b;
        try {
            b = FileInfo.toByteArray(fileInfo);
        }
        catch (IOException e) {
            throw new RecordStoreException(e.toString());
        }
        RecordStoreUtil.saveByteArray(LAST_FILE_INFO, b);
    }

    public static FileInfo loadCurrentFileInfo() throws IOException, RecordStoreException, RecordStoreFullException, RecordStoreNotFoundException {
        byte[] b = RecordStoreUtil.loadByteArray(LAST_FILE_INFO);
        return FileInfo.fromByteArray(b);
    }

    public static void saveSettings(Settings settings) throws RecordStoreException, RecordStoreFullException, RecordStoreNotFoundException {
        byte[] b;
        try {
            b = Settings.toByteArray(settings);
        }
        catch (IOException e) {
            throw new RecordStoreException(e.toString());
        }
        RecordStoreUtil.saveByteArray(SETTINGS, b);
    }

    public static Settings loadSettings() throws IOException, RecordStoreException, RecordStoreFullException, RecordStoreNotFoundException {
        byte[] b = RecordStoreUtil.loadByteArray(SETTINGS);
        return Settings.fromByteArray(b);
    }
}

