/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Stack;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;

public class FileUtil {
    private static final Object FILE_LOCK = new Object();
    private static final int SKIP_STEP = 8192;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Enumeration getFileNames(String directoryPath) throws IOException {
        FileConnection fc = null;
        Object object = FILE_LOCK;
        synchronized (object) {
            try {
                fc = (FileConnection)Connector.open((String)directoryPath);
                if (fc.exists()) {
                    if (fc.isDirectory()) {
                        Enumeration enumeration = fc.list("*", true);
                        return enumeration;
                    }
                    throw new IOException(String.valueOf(directoryPath) + "is  not directory.");
                }
                throw new IOException("Directory Not Found.");
            }
            finally {
                if (fc != null) {
                    fc.close();
                }
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static FileInfo getFileContent(String filePath, int offset, Stack offsetStack) throws IOException {
        FileConnection fc = null;
        InputStream is = null;
        FileInfo info = null;
        Object object = FILE_LOCK;
        synchronized (object) {
            try {
                fc = (FileConnection)Connector.open((String)filePath);
                if (fc.exists()) {
                    if (!fc.isDirectory()) {
                        int ret;
                        byte[] buffer;
                        long length = fc.fileSize();
                        boolean isOverflow = false;
                        if (length > (long)(offset + 65536)) {
                            buffer = new byte[65536];
                            isOverflow = true;
                        } else {
                            buffer = new byte[(int)length - offset];
                        }
                        is = fc.openInputStream();
                        int skip = 0;
                        byte[] tmp = new byte[8192];
                        while (offset > skip) {
                            if (offset - skip > 8192) {
                                ret = is.read(tmp);
                                skip += ret;
                                continue;
                            }
                            ret = is.read(tmp, 0, offset - skip);
                            skip += ret;
                        }
                        ret = is.read(buffer);
                        if (ret != buffer.length) {
                            throw new IOException("read() is not blocked.");
                        }
                        if (isOverflow) {
                            int i = buffer.length - 1;
                            while (i > 0) {
                                if (buffer[i] == 10 && buffer[i - 1] == 13) break;
                                --i;
                            }
                            info = new FileInfo(new String(buffer, 0, i, "Shift_JIS"), filePath, (int)length, offset, offset + i, offsetStack);
                        } else {
                            info = new FileInfo(new String(buffer, "Shift_JIS"), filePath, (int)length, offset, (int)length, offsetStack);
                        }
                        FileInfo fileInfo = info;
                        return fileInfo;
                    }
                    throw new IOException(String.valueOf(filePath) + "is  directory.");
                }
                throw new IOException("File not Found");
            }
            finally {
                if (is != null) {
                    is.close();
                }
                if (fc != null) {
                    fc.close();
                }
            }
        }
    }
}

