/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Stack;
import javax.microedition.lcdui.Font;

public class FileInfo {
    private String content;
    private String path;
    private int length;
    private int offset;
    private int end;
    private Stack offsetStack;
    private int lineNumber = 0;
    private boolean isTategaki;
    private int plainTextSize;
    private int rubyTextSize;
    public static final int MAX_CONTENT_LENGTH = 65536;
    public static final String FILE_ENCODING = "Shift_JIS";
    private static final int FILE_INFO_FORMAT_VERSION = 1;
    private static final int FILE_INFO_FORMAT_VERSION_0 = 0;

    public FileInfo(String content, String path, int length, int offset, int end, Stack offsetStack) {
        this(content, path, length, offset, end, offsetStack, 0, Settings.getInstance().isTategaki(), Settings.getInstance().getPlainTextSize(), Settings.getInstance().getRubyTextSize());
    }

    private FileInfo(String content, String path, int length, int offset, int end, Stack offsetStack, int lineNumber, boolean isTategaki, int plainFontsize, int rubyFontSize) {
        this.content = content;
        this.path = path;
        this.length = length;
        this.offset = offset;
        this.end = end;
        this.offsetStack = offsetStack != null ? offsetStack : new Stack();
        this.lineNumber = lineNumber;
        this.isTategaki = isTategaki;
        this.plainTextSize = plainFontsize;
        this.rubyTextSize = rubyFontSize;
    }

    public boolean hasNext() {
        return this.end < this.length;
    }

    public boolean hasPrev() {
        return this.offset > 0;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("FileInfo: path =" + this.path + "\n");
        buffer.append("length =" + this.length + "\n");
        buffer.append("offset =" + this.offset + "\n");
        buffer.append("end =" + this.end + "\n");
        buffer.append("lineNumber=" + this.lineNumber + "\n");
        buffer.append("isTategaki=" + this.isTategaki + "\n");
        int i = 0;
        while (i < this.offsetStack.size()) {
            buffer.append("offsetStack" + i + " : " + this.offsetStack.elementAt(i) + "\n");
            ++i;
        }
        buffer.append("plainTextFontSize=" + this.plainTextSize + "\n");
        buffer.append("rubyTextFontSize=" + this.rubyTextSize + "\n");
        return buffer.toString();
    }

    public Stack getOffsetStack() {
        return this.offsetStack;
    }

    public void setOffsetStack(Stack offsetStack) {
        this.offsetStack = offsetStack;
    }

    public int getEnd() {
        return this.end;
    }

    public int getOffset() {
        return this.offset;
    }

    public String getContent() {
        return this.content;
    }

    public int getLength() {
        return this.length;
    }

    public String getPath() {
        return this.path;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public boolean isTategaki() {
        return this.isTategaki;
    }

    public void setTategaki(boolean isTategaki) {
        this.isTategaki = isTategaki;
    }

    public Font getPlainTextFont() {
        if (this.plainTextSize == 32) {
            this.plainTextSize = 0;
        }
        return Font.getFont((int)0, (int)0, (int)this.plainTextSize);
    }

    public Font getRubyTextFont() {
        if (this.rubyTextSize == 32) {
            return null;
        }
        return Font.getFont((int)0, (int)0, (int)this.rubyTextSize);
    }

    public static byte[] toByteArray(FileInfo fileInfo) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        byte[] b = null;
        try {
            dos.writeInt(1);
            dos.writeUTF(fileInfo.getPath());
            dos.writeInt(fileInfo.getOffset());
            dos.writeInt(fileInfo.getLineNumber());
            dos.writeBoolean(fileInfo.isTategaki());
            if (fileInfo.getOffsetStack() != null) {
                int size = fileInfo.getOffsetStack().size();
                dos.writeInt(size);
                int i = 0;
                while (i < size) {
                    dos.writeInt((Integer)fileInfo.getOffsetStack().elementAt(i));
                    ++i;
                }
            } else {
                dos.writeInt(0);
            }
            dos.writeInt(fileInfo.getPlainTextSize());
            dos.writeInt(fileInfo.getRubyTextSize());
            b = baos.toByteArray();
        }
        finally {
            dos.close();
        }
        return b;
    }

    public static FileInfo fromByteArray(byte[] b) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(b);
        DataInputStream dis = new DataInputStream(bais);
        FileInfo fileInfo = null;
        try {
            int rubyFontSize;
            int plainFontSize;
            int version = dis.readInt();
            if (version > 1) {
                throw new IOException("\u30d0\u30fc\u30b8\u30e7\u30f3\u304c\u7570\u306a\u308a\u307e\u3059");
            }
            String path = dis.readUTF();
            int offset = dis.readInt();
            int lineNumber = dis.readInt();
            boolean isTategaki = dis.readBoolean();
            int offsetSize = dis.readInt();
            Stack<Integer> offsetStack = new Stack<Integer>();
            int i = 0;
            while (i < offsetSize) {
                offsetStack.addElement(new Integer(dis.readInt()));
                ++i;
            }
            if (version > 0) {
                plainFontSize = dis.readInt();
                rubyFontSize = dis.readInt();
            } else {
                plainFontSize = Settings.getInstance().getPlainTextSize();
                rubyFontSize = Settings.getInstance().getRubyTextSize();
            }
            fileInfo = FileUtil.getFileContent(path, offset, offsetStack);
            fileInfo.setLineNumber(lineNumber);
            fileInfo.setTategaki(isTategaki);
            fileInfo.setPlainTextSize(plainFontSize);
            fileInfo.setRubyTextSize(rubyFontSize);
        }
        finally {
            dis.close();
        }
        return fileInfo;
    }

    public int getPlainTextSize() {
        return this.plainTextSize;
    }

    public void setPlainTextSize(int plainFontSize) {
        this.plainTextSize = plainFontSize;
    }

    public int getRubyTextSize() {
        return this.rubyTextSize;
    }

    public void setRubyTextSize(int rubyFontSize) {
        this.rubyTextSize = rubyFontSize;
    }
}

