/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.io.file.FileSystemRegistry;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.Ticker;

public class DirectoryList
extends List
implements CommandListener,
Runnable {
    private final Command CMD_SETTEI = new Command("\u8a2d\u5b9a", 1, 10);
    private final Command CMD_SELECT = new Command("Open", 8, 1);
    private final Command CMD_SIORI_LIST = new Command("\u3057\u304a\u308a\u306e\u30ea\u30b9\u30c8", 1, 10);
    private volatile String directoryName;
    private Vector isDirectory = new Vector();
    private static final String PARENT_DIRECTORY_NAME = "..";
    private static final String TOP_DIRECTORY_NAME = "file:///";
    private static DirectoryList directoryList = new DirectoryList();

    public static DirectoryList getInstance(String directoryName) {
        directoryList.init(directoryName);
        return directoryList;
    }

    private DirectoryList() {
        super("", 3);
        this.setSelectCommand(this.CMD_SELECT);
        this.addCommand(this.CMD_SETTEI);
        this.addCommand(this.CMD_SIORI_LIST);
        this.setCommandListener(this);
    }

    private void init(String directoryName) {
        Enumeration fileEnumeration = null;
        this.directoryName = directoryName;
        this.setTitle(directoryName);
        this.deleteAll();
        this.isDirectory.removeAllElements();
        if (directoryName.equals(TOP_DIRECTORY_NAME)) {
            fileEnumeration = FileSystemRegistry.listRoots();
        } else {
            try {
                fileEnumeration = FileUtil.getFileNames(directoryName);
                this.append(PARENT_DIRECTORY_NAME, null);
                this.isDirectory.addElement(Boolean.TRUE);
            }
            catch (Exception e) {
                this.init(TOP_DIRECTORY_NAME);
                return;
            }
        }
        if (fileEnumeration != null) {
            while (fileEnumeration.hasMoreElements()) {
                String filename = (String)fileEnumeration.nextElement();
                if (filename.toLowerCase().endsWith(".txt")) {
                    this.append(filename, null);
                    this.isDirectory.addElement(Boolean.FALSE);
                    continue;
                }
                if (!filename.endsWith("/")) continue;
                this.append(filename, null);
                this.isDirectory.addElement(Boolean.TRUE);
            }
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.CMD_SELECT) {
            new Thread(this).start();
        } else if (command == this.CMD_SETTEI) {
            AozoraMIDlet.getDisplay().setCurrent((Displayable)SettingsForm.getInstance((Displayable)this));
        } else if (command == this.CMD_SIORI_LIST) {
            AozoraMIDlet.getDisplay().setCurrent((Displayable)BookmarksList.getInstance((Displayable)this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        DirectoryList directoryList = this;
        synchronized (directoryList) {
            try {
                FileInfo fileInfo = null;
                try {
                    try {
                        if (((Boolean)this.isDirectory.elementAt(this.getSelectedIndex())).booleanValue()) {
                            String chileName = this.getString(this.getSelectedIndex());
                            if (chileName.equals(PARENT_DIRECTORY_NAME)) {
                                int index = this.directoryName.lastIndexOf(47, this.directoryName.length() - 2);
                                this.directoryName = this.directoryName.substring(0, index + 1);
                            } else {
                                this.directoryName = String.valueOf(this.directoryName) + chileName;
                            }
                            this.init(this.directoryName);
                            return;
                        }
                        this.setTicker(new Ticker("\u30d5\u30a1\u30a4\u30eb\u8aad\u307f\u8fbc\u307f\u4e2d"));
                        fileInfo = FileUtil.getFileContent(String.valueOf(this.directoryName) + this.getString(this.getSelectedIndex()), 0, null);
                    }
                    finally {
                        this.setTicker(null);
                    }
                }
                catch (OutOfMemoryError e) {
                    Alert alert = new Alert("\u30d5\u30a1\u30a4\u30eb\u304c\u5927\u304d\u3059\u304e\u307e\u3059", "\u30d5\u30a1\u30a4\u30eb\u304c\u5927\u304d\u3059\u304e\u307e\u3059" + e, null, null);
                    AozoraMIDlet.getDisplay().setCurrent((Displayable)alert);
                    return;
                }
                if (fileInfo == null) {
                    Alert alert = new Alert("\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f", "\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f", null, null);
                    AozoraMIDlet.getDisplay().setCurrent((Displayable)alert);
                    return;
                }
                AozoraCanvas canvas = null;
                try {
                    canvas = AozoraCanvas.getInstance(this, fileInfo);
                    AozoraMIDlet.getDisplay().setCurrent((Displayable)canvas);
                }
                catch (OutOfMemoryError e) {
                    System.err.println("AozoraCanvas(): " + e);
                    e.printStackTrace();
                    Alert alert = new Alert("\u30d5\u30a1\u30a4\u30eb\u304c\u5927\u304d\u3059\u304e\u307e\u3059", "\u30d5\u30a1\u30a4\u30eb\u304c\u5927\u304d\u3059\u304e\u307e\u3059", null, null);
                    AozoraMIDlet.getDisplay().setCurrent((Displayable)alert);
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
    }
}

