/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.Ticker;

public class BookmarksList
extends List
implements CommandListener,
Runnable {
    private final Command CMD_CANCEL = new Command("CANCEL", 3, 1);
    private final Command CMD_SELECT = new Command("\u9078\u629e", 8, 1);
    private final Command CMD_SAKUZYO = new Command("\u524a\u9664", 8, 1);
    private Displayable previousDisplayable;
    private static BookmarksList bookmarksList = new BookmarksList();

    public static BookmarksList getInstance(Displayable displayable) {
        BookmarksList.bookmarksList.previousDisplayable = displayable;
        bookmarksList.init();
        return bookmarksList;
    }

    private BookmarksList() {
        super("\u3057\u304a\u308a\u306e\u30ea\u30b9\u30c8", 3);
        this.setSelectCommand(this.CMD_SELECT);
        this.addCommand(this.CMD_CANCEL);
        this.addCommand(this.CMD_SAKUZYO);
        this.setCommandListener(this);
    }

    private void init() {
        this.deleteAll();
        Enumeration enumeration = Bookmarks.getInstance().elements();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Bookmark bookmark = (Bookmark)enumeration.nextElement();
                this.append(bookmark.getName(), null);
            }
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.CMD_SELECT) {
            new Thread(this).start();
        } else if (command == this.CMD_SAKUZYO) {
            Bookmarks.getInstance().removeElementAt(this.getSelectedIndex());
            try {
                RecordStoreUtil.saveBookmarks(Bookmarks.getInstance());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.init();
        } else if (command == this.CMD_CANCEL) {
            if (this.previousDisplayable instanceof AozoraCanvas) {
                ((AozoraCanvas)this.previousDisplayable).finalizeSettei(false);
            }
            AozoraMIDlet.getDisplay().setCurrent(this.previousDisplayable);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        String directoryPath;
        FileInfo fileInfo;
        Bookmark bookmark = Bookmarks.getInstance().elementAt(this.getSelectedIndex());
        try {
            try {
                this.setTicker(new Ticker("\u30d5\u30a1\u30a4\u30eb\u8aad\u307f\u8fbc\u307f\u4e2d"));
                fileInfo = FileUtil.getFileContent(bookmark.getPath(), bookmark.getOffset(), bookmark.getOffsetStack());
                fileInfo.setLineNumber(bookmark.getLineNumber());
                fileInfo.setTategaki(bookmark.isTategaki());
                fileInfo.setPlainTextSize(bookmark.getPlainTextSize());
                fileInfo.setRubyTextSize(bookmark.getRubyTextSize());
            }
            catch (Exception e) {
                e.printStackTrace();
                Alert alert = new Alert("\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f", "\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f", null, null);
                AozoraMIDlet.getDisplay().setCurrent((Displayable)alert);
                this.setTicker(null);
                return;
            }
            int index = fileInfo.getPath().lastIndexOf(47);
            directoryPath = fileInfo.getPath().substring(0, index + 1);
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
            Alert alert = new Alert("OutOfMemoryError", "OutOfMemoryError", null, null);
            AozoraMIDlet.getDisplay().setCurrent((Displayable)alert);
            return;
        }
        {
            DirectoryList directoryList = DirectoryList.getInstance(directoryPath);
            if (this.previousDisplayable instanceof AozoraCanvas) {
                AozoraCanvas canvas = (AozoraCanvas)this.previousDisplayable;
                canvas.setDirectoryList(directoryList);
                canvas.setFileInfo(fileInfo);
                AozoraMIDlet.getDisplay().setCurrent((Displayable)canvas);
                return;
            }
            AozoraCanvas canvas = AozoraCanvas.getInstance(directoryList, fileInfo);
            AozoraMIDlet.getDisplay().setCurrent((Displayable)canvas);
            return;
        }
        finally {
            this.setTicker(null);
        }
    }
}

