/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Stack;

public class Bookmark {
    private String name;
    private String path;
    private int length;
    private int offset;
    private int end;
    private Stack offsetStack;
    private int lineNumber = 0;
    private boolean isTategaki;
    private int plainTextSize;
    private int rubyTextSize;
    private static final int BOOKMARK_FORMAT_VERSION = 0;

    private Bookmark(String name, String path, int length, int offset, int end, Stack offsetStack, int lineNumber, boolean isTategaki, int plainTextSize, int rubyTextSize) {
        this.name = name;
        this.path = path;
        this.length = length;
        this.offset = offset;
        this.end = end;
        this.offsetStack = new Stack();
        int i = 0;
        while (i < offsetStack.size()) {
            this.offsetStack.addElement(offsetStack.elementAt(i));
            ++i;
        }
        this.lineNumber = lineNumber;
        this.isTategaki = isTategaki;
        this.plainTextSize = plainTextSize;
        this.rubyTextSize = rubyTextSize;
    }

    public static Bookmark getInstance(FileInfo fileInfo) {
        return new Bookmark(String.valueOf(fileInfo.getPath()) + " " + (fileInfo.getOffsetStack().size() + 1) + "\u30da\u30fc\u30b8 " + fileInfo.getLineNumber() + "\u884c\u76ee", fileInfo.getPath(), fileInfo.getLength(), fileInfo.getOffset(), fileInfo.getEnd(), fileInfo.getOffsetStack(), fileInfo.getLineNumber(), fileInfo.isTategaki(), fileInfo.getPlainTextSize(), fileInfo.getRubyTextSize());
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public boolean isTategaki() {
        return this.isTategaki;
    }

    public void setTategaki(boolean isTategaki) {
        this.isTategaki = isTategaki;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public Stack getOffsetStack() {
        return this.offsetStack;
    }

    public void setOffsetStack(Stack offsetStack) {
        this.offsetStack = offsetStack;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public int getPlainTextSize() {
        return this.plainTextSize;
    }

    public void setPlainTextSize(int plainTextSize) {
        this.plainTextSize = plainTextSize;
    }

    public int getRubyTextSize() {
        return this.rubyTextSize;
    }

    public void setRubyTextSize(int rubyTextSize) {
        this.rubyTextSize = rubyTextSize;
    }

    public static byte[] toByteArray(Bookmark bookmark) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        byte[] b = null;
        try {
            dos.writeInt(0);
            dos.writeUTF(bookmark.getName());
            dos.writeUTF(bookmark.getPath());
            dos.writeInt(bookmark.getLength());
            dos.writeInt(bookmark.getOffset());
            dos.writeInt(bookmark.getEnd());
            dos.writeInt(bookmark.getLineNumber());
            dos.writeBoolean(bookmark.isTategaki());
            dos.writeInt(bookmark.getPlainTextSize());
            dos.writeInt(bookmark.getRubyTextSize());
            if (bookmark.getOffsetStack() != null) {
                int size = bookmark.getOffsetStack().size();
                dos.writeInt(size);
                int i = 0;
                while (i < size) {
                    dos.writeInt((Integer)bookmark.getOffsetStack().elementAt(i));
                    ++i;
                }
            } else {
                dos.writeInt(0);
            }
            b = baos.toByteArray();
        }
        finally {
            dos.close();
        }
        return b;
    }

    public static Bookmark fromByteArray(byte[] b) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(b);
        DataInputStream dis = new DataInputStream(bais);
        Bookmark bookmark = null;
        try {
            int version = dis.readInt();
            if (version > 0) {
                throw new IOException("\u30d0\u30fc\u30b8\u30e7\u30f3\u304c\u7570\u306a\u308a\u307e\u3059");
            }
            String name = dis.readUTF();
            String path = dis.readUTF();
            int length = dis.readInt();
            int offset = dis.readInt();
            int end = dis.readInt();
            int lineNumber = dis.readInt();
            boolean isTategaki = dis.readBoolean();
            int plainFontSize = dis.readInt();
            int rubyFontSize = dis.readInt();
            int offsetSize = dis.readInt();
            Stack<Integer> offsetStack = new Stack<Integer>();
            int i = 0;
            while (i < offsetSize) {
                offsetStack.addElement(new Integer(dis.readInt()));
                ++i;
            }
            bookmark = new Bookmark(name, path, length, offset, end, offsetStack, lineNumber, isTategaki, plainFontSize, rubyFontSize);
        }
        finally {
            dis.close();
        }
        return bookmark;
    }
}

