/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Ticker;
import javax.microedition.lcdui.game.GameCanvas;

public class AozoraCanvas
extends GameCanvas
implements CommandListener,
Runnable {
    private static final Ticker TICKER_YOKOTATE_KIRIKAETYU = new Ticker("\u6a2a/\u7e26\u5207\u308a\u5909\u3048\u4e2d");
    private static final Ticker TICKER_FILE_INFO_SYUSYUTYU = new Ticker("\u30d5\u30a1\u30a4\u30eb\u60c5\u5831\u306e\u53ce\u96c6\u4e2d");
    private static final Ticker TICKER_FILE_YOMIKOMITYU = new Ticker("\u30d5\u30a1\u30a4\u30eb\u8aad\u307f\u8fbc\u307f\u4e2d");
    private int zeroPoint;
    private int initialZeroPoint;
    private int lineWidthOrHeight;
    private int leastCharNumber;
    private DirectoryList directoryList;
    private Vector fileStrings;
    private Vector tategakiFileStrings;
    private Vector strings;
    private final Command CMD_KIRIKAE = new Command("\u6a2a/\u7e26", 1, 10);
    private final Command CMD_BACK = new Command("Back", 2, 1);
    private final Command CMD_SETTEI = new Command("\u8a2d\u5b9a", 1, 10);
    private final Command CMD_SIORI_TUIKA = new Command("\u3057\u304a\u308a\u3092\u8ffd\u52a0", 1, 10);
    private final Command CMD_SIORI_LIST = new Command("\u3057\u304a\u308a\u306e\u30ea\u30b9\u30c8", 1, 10);
    private boolean isTategaki = false;
    private FileInfo fileInfo;
    private int allOfLineNumbers;
    private int lineNumber;
    private int[] fileLineNumbers;
    private int fileLineNumber;
    private Display display = AozoraMIDlet.getDisplay();
    private boolean doKeyPressed;
    private boolean doKirikae;
    private boolean doPaint;
    private boolean doPrev;
    private boolean doNext;
    private boolean doSettei;
    private Settings settings = Settings.getInstance();
    private Font plainTextFont;
    private Font rubyTextFont;
    private int step;
    private int fastStep;
    private int textColor;
    private int backGroundColor;
    private int widthBetweenPlains;
    private int widthBetweenPlainAndRuby;
    private int widthBetweenRubyAndPlain;
    private Thread keyProcessThread = null;
    private static AozoraCanvas aozoraCanvas = new AozoraCanvas();

    public static AozoraCanvas getInstance(DirectoryList directoryList, FileInfo fileInfo) {
        AozoraCanvas.aozoraCanvas.directoryList = directoryList;
        AozoraCanvas.aozoraCanvas.fileInfo = fileInfo;
        aozoraCanvas.setUpStrings();
        return aozoraCanvas;
    }

    private AozoraCanvas() {
        super(false);
        this.addCommand(this.CMD_BACK);
        this.addCommand(this.CMD_KIRIKAE);
        this.addCommand(this.CMD_SETTEI);
        this.addCommand(this.CMD_SIORI_TUIKA);
        this.addCommand(this.CMD_SIORI_LIST);
        this.setCommandListener(this);
    }

    private void setUpSettingInfos() {
        this.step = this.settings.getStep();
        this.fastStep = this.settings.getFastStep();
        this.textColor = this.settings.getTextColor();
        this.backGroundColor = this.settings.getBackgroundColor();
        this.widthBetweenPlains = this.settings.getWidthBetweenPlains();
        this.widthBetweenPlainAndRuby = this.settings.getWidthBetweenPlainAndRuby();
        this.widthBetweenRubyAndPlain = this.settings.getWidthBetweenRubyAndPlain();
        this.plainTextFont = this.fileInfo.getPlainTextFont();
        this.rubyTextFont = this.fileInfo.getRubyTextFont();
    }

    private void setUpStrings() {
        this.setTicker(TICKER_FILE_INFO_SYUSYUTYU);
        this.fileStrings = this.splitString(this.fileInfo.getContent());
        this.fileLineNumbers = new int[this.fileStrings.size()];
        this.setUpStates();
    }

    private void setUpStates() {
        this.setUpSettingInfos();
        if (this.keyProcessThread == null) {
            this.keyProcessThread = new Thread(this);
            this.keyProcessThread.start();
        }
        this.allOfLineNumbers = 0;
        this.isTategaki = this.fileInfo.isTategaki();
        if (this.isTategaki) {
            this.strings = this.tategakiFileStrings != null ? this.tategakiFileStrings : (this.tategakiFileStrings = TategakiUtil.convertToTategakiStrings(this.fileStrings));
            if (this.rubyTextFont != null) {
                this.initialZeroPoint = this.getWidth() - this.rubyTextFont.stringWidth("\u3042");
                this.lineWidthOrHeight = this.rubyTextFont.stringWidth("\u3042") + this.plainTextFont.stringWidth("\u3042") + this.widthBetweenPlainAndRuby + this.widthBetweenRubyAndPlain;
            } else {
                this.initialZeroPoint = this.getWidth();
                this.lineWidthOrHeight = this.plainTextFont.stringWidth("\u3042") + this.widthBetweenPlains;
            }
            this.leastCharNumber = this.getHeight() / this.plainTextFont.getHeight();
        } else {
            if (this.rubyTextFont != null) {
                this.initialZeroPoint = this.rubyTextFont.getHeight();
                this.lineWidthOrHeight = this.rubyTextFont.getHeight() + this.plainTextFont.getHeight() + this.widthBetweenPlainAndRuby + this.widthBetweenRubyAndPlain;
            } else {
                this.initialZeroPoint = 0;
                this.lineWidthOrHeight = this.plainTextFont.getHeight() + this.widthBetweenPlains;
            }
            this.leastCharNumber = this.getWidth() / this.plainTextFont.stringWidth("\u3042");
            this.strings = this.fileStrings;
            if (this.tategakiFileStrings == null) {
                new Thread(){

                    public void run() {
                        AozoraCanvas.this.tategakiFileStrings = TategakiUtil.convertToTategakiStrings(AozoraCanvas.this.fileStrings);
                    }
                }.start();
            }
        }
        this.doPaint = false;
        new Thread(){

            public void run() {
                int all = 0;
                int kirikaeLineNumber = 0;
                int size = AozoraCanvas.this.strings.size();
                int i = 0;
                while (i < size) {
                    ((AozoraCanvas)AozoraCanvas.this).fileLineNumbers[i] = 0;
                    AozoraCanvas.this.parseAndDrawString(null, (String)AozoraCanvas.this.strings.elementAt(i), 0, i, false);
                    all += AozoraCanvas.this.fileLineNumbers[i];
                    if (AozoraCanvas.this.fileLineNumber > i) {
                        kirikaeLineNumber += AozoraCanvas.this.fileLineNumbers[i];
                    }
                    ++i;
                }
                AozoraCanvas.this.allOfLineNumbers = all;
                if (AozoraCanvas.this.doNext) {
                    AozoraCanvas.this.setLineNumber(0);
                } else if (AozoraCanvas.this.doPrev) {
                    AozoraCanvas.this.setLineNumber(AozoraCanvas.this.allOfLineNumbers - 7);
                } else if (AozoraCanvas.this.doKirikae) {
                    AozoraCanvas.this.setLineNumber(kirikaeLineNumber);
                } else {
                    AozoraCanvas.this.setLineNumber(AozoraCanvas.this.fileInfo.getLineNumber());
                }
                AozoraCanvas.this.doNext = false;
                AozoraCanvas.this.doPrev = false;
                AozoraCanvas.this.doKirikae = false;
                AozoraCanvas.this.doSettei = false;
                AozoraCanvas.this.doPaint = true;
                AozoraCanvas.this.setTicker(null);
                AozoraCanvas.this.repaint();
            }
        }.start();
    }

    private Vector splitString(String string) {
        Vector<String> vector = new Vector<String>();
        int indexBegin = 0;
        if (this.fileInfo.hasPrev()) {
            vector.addElement("--- \u3053\u308c\u3088\u308a\u524d\u306e\u6587\u7ae0\u3092\u8aad\u3080\u306b\u306f[7]\u30ad\u30fc\u3092\u62bc\u3057\u3066\u304f\u3060\u3055\u3044---");
            vector.addElement("");
        }
        while (true) {
            int indexEnd;
            if ((indexEnd = string.indexOf("\r\n", indexBegin)) == -1) break;
            vector.addElement(this.ignoreRubyStartingChar(string.substring(indexBegin, indexEnd)));
            indexBegin = indexEnd + 2;
        }
        vector.addElement(this.ignoreRubyStartingChar(string.substring(indexBegin)));
        if (this.fileInfo.hasNext()) {
            vector.addElement("");
            vector.addElement("--- \u3053\u308c\u3088\u308a\u5f8c\u306e\u6587\u7ae0\u3092\u8aad\u3080\u306b\u306f[9]\u30ad\u30fc\u3092\u62bc\u3057\u3066\u304f\u3060\u3055\u3044---");
        }
        return vector;
    }

    private void drawPlainString(Graphics g, String string, int point) {
        if (this.isTategaki) {
            if (point >= 0) {
                g.setFont(this.plainTextFont);
                this.drawTategakiString(g, string, point, 0, 24, this.plainTextFont.getHeight());
            }
        } else if (point >= 0) {
            g.setFont(this.plainTextFont);
            g.drawString(string, 0, point, 20);
        }
    }

    private void drawTategakiString(Graphics g, String string, int x, int y, int anchor, int fontHeight) {
        int charWidth = g.getFont().stringWidth("\u3042'");
        int length = string.length();
        int i = 0;
        while (i < length) {
            g.drawChar(string.charAt(i), (int)((double)x + (double)charWidth * TategakiUtil.doZursu(string.charAt(i))), y + fontHeight * i, anchor);
            ++i;
        }
    }

    private void drawRubyString(Graphics g, String string, int x, int y) {
        if (this.isTategaki) {
            if (x >= 0 && this.rubyTextFont != null) {
                g.setFont(this.rubyTextFont);
                int i = y - this.rubyTextFont.getHeight() * string.length();
                if (i < 0) {
                    i = 0;
                }
                this.drawTategakiString(g, string, x + this.widthBetweenRubyAndPlain, i, 20, this.rubyTextFont.getHeight());
            }
        } else if (y >= 0 && this.rubyTextFont != null) {
            g.setFont(this.rubyTextFont);
            if (this.rubyTextFont.stringWidth(string) < x) {
                g.drawString(string, x, y - this.widthBetweenRubyAndPlain, 40);
            } else {
                g.drawString(string, 0, y - this.widthBetweenRubyAndPlain, 36);
            }
        }
    }

    private String ignoreRubyStartingChar(String string) {
        int indexBegin = 0;
        StringBuffer buffer = new StringBuffer();
        while (true) {
            int indexTatesen = indexBegin;
            indexTatesen = this.isTategaki ? string.indexOf(8213, indexBegin) : string.indexOf(65372, indexBegin);
            if (indexTatesen == -1) break;
            buffer.append(string.substring(indexBegin, indexTatesen));
            indexBegin = indexTatesen + 1;
        }
        buffer.append(string.substring(indexBegin));
        return buffer.toString();
    }

    private String prosessString(String string, Vector rubyVector) {
        int indexBegin = 0;
        StringBuffer buffer = new StringBuffer();
        int rubyDiff = 0;
        while (true) {
            int indexRubyOpen;
            if ((indexRubyOpen = string.indexOf(12298, indexBegin)) == -1) break;
            int indexRubyClose = string.indexOf(12299, indexRubyOpen);
            if (indexRubyClose == -1) {
                Alert alert = new Alert("\u30eb\u30d3\u304c\u9589\u3058\u3089\u308c\u3066\u3044\u307e\u305b\u3093", "\u30eb\u30d3\u304c\u9589\u3058\u3089\u308c\u3066\u3044\u307e\u305b\u3093", null, null);
                this.display.setCurrent((Displayable)alert);
                throw new IllegalArgumentException("ruby is not closed");
            }
            if (indexRubyOpen + 1 < indexRubyClose) {
                RubyInfo info = new RubyInfo(indexRubyOpen - rubyDiff, string.substring(indexRubyOpen + 1, indexRubyClose));
                rubyVector.addElement(info);
                rubyDiff += indexRubyClose - indexRubyOpen + 1;
            }
            buffer.append(string.substring(indexBegin, indexRubyOpen));
            indexBegin = indexRubyClose + 1;
        }
        buffer.append(string.substring(indexBegin));
        return buffer.toString();
    }

    private int movePaintingPoint(int point) {
        if (this.isTategaki) {
            return point - this.lineWidthOrHeight;
        }
        return point + this.lineWidthOrHeight;
    }

    private RubyInfo drawRubyStrings(Graphics g, RubyInfo rubyInfo, Enumeration e, String string, int point, int index) {
        while (rubyInfo != null) {
            if (rubyInfo.getIndex() > index + string.length()) {
                return rubyInfo;
            }
            if (this.isTategaki) {
                this.drawRubyString(g, rubyInfo.getRuby(), point, (rubyInfo.getIndex() - index) * this.plainTextFont.getHeight());
            } else {
                this.drawRubyString(g, rubyInfo.getRuby(), this.plainTextFont.substringWidth(string, 0, rubyInfo.getIndex() - index), point);
            }
            if (e.hasMoreElements()) {
                rubyInfo = (RubyInfo)e.nextElement();
                continue;
            }
            return null;
        }
        return null;
    }

    private int parseAndDrawString(Graphics g, String string, int point, int lineNumber, boolean isDrawing) {
        int count;
        block11: {
            Vector rubyVector = new Vector();
            int indexBegin = 0;
            String processedString = this.prosessString(string, rubyVector);
            Enumeration e = rubyVector.elements();
            RubyInfo rubyInfo = null;
            if (e.hasMoreElements()) {
                rubyInfo = (RubyInfo)e.nextElement();
            }
            count = 0;
            indexBegin = 0;
            while (true) {
                if (processedString.substring(indexBegin).length() <= this.leastCharNumber) {
                    if (isDrawing) {
                        this.drawPlainString(g, processedString.substring(indexBegin), point);
                        rubyInfo = this.drawRubyStrings(g, rubyInfo, e, processedString.substring(indexBegin), point, indexBegin);
                    }
                    point = this.movePaintingPoint(point);
                    ++count;
                    break block11;
                }
                if (this.isTategaki) {
                    if (isDrawing) {
                        this.drawPlainString(g, processedString.substring(indexBegin, indexBegin + this.leastCharNumber), point);
                        rubyInfo = this.drawRubyStrings(g, rubyInfo, e, processedString.substring(indexBegin, indexBegin + this.leastCharNumber), point, indexBegin);
                    }
                    indexBegin += this.leastCharNumber;
                    point = this.movePaintingPoint(point);
                    ++count;
                    continue;
                }
                int end = processedString.length();
                boolean isItigyo = true;
                int i = indexBegin + this.leastCharNumber;
                while (i < end) {
                    if (this.plainTextFont.substringWidth(processedString, indexBegin, i - indexBegin + 1) > this.getWidth()) {
                        if (isDrawing) {
                            this.drawPlainString(g, processedString.substring(indexBegin, i - 1), point);
                            rubyInfo = this.drawRubyStrings(g, rubyInfo, e, processedString.substring(indexBegin, i - 1), point, indexBegin);
                        }
                        indexBegin = i - 1;
                        point = this.movePaintingPoint(point);
                        ++count;
                        isItigyo = false;
                        break;
                    }
                    ++i;
                }
                if (isItigyo) break;
            }
            if (isDrawing) {
                this.drawPlainString(g, processedString.substring(indexBegin), point);
                rubyInfo = this.drawRubyStrings(g, rubyInfo, e, processedString.substring(indexBegin), point, indexBegin);
            }
            point = this.movePaintingPoint(point);
            ++count;
        }
        if (this.fileLineNumbers[lineNumber] == 0) {
            this.fileLineNumbers[lineNumber] = count;
        }
        return point;
    }

    private void parseAndDrawFileContent(Graphics g) {
        int fileLine = 0;
        int lines = 0;
        int length = this.fileLineNumbers.length;
        while (fileLine < length) {
            if (this.fileLineNumbers[fileLine] == 0) break;
            if (this.lineNumber < (lines += this.fileLineNumbers[fileLine])) {
                lines -= this.fileLineNumbers[fileLine];
                break;
            }
            ++fileLine;
        }
        int point = this.isTategaki ? this.zeroPoint - lines * this.lineWidthOrHeight : this.zeroPoint + lines * this.lineWidthOrHeight;
        this.fileLineNumber = fileLine;
        if (fileLine > 0 && this.fileLineNumbers[fileLine - 1] > 1) {
            ++this.fileLineNumber;
        }
        int size = this.strings.size();
        while (fileLine < size) {
            point = this.parseAndDrawString(g, (String)this.strings.elementAt(fileLine), point, fileLine, true);
            if (this.isTategaki ? point < 0 : point > this.getHeight()) break;
            ++fileLine;
        }
    }

    public void paint(Graphics g) {
        g.setColor(this.backGroundColor);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.doPaint) {
            g.setColor(this.textColor);
            if (this.allOfLineNumbers > 0) {
                if (this.isTategaki) {
                    g.drawLine(0, this.getHeight() - 4, this.getWidth(), this.getHeight() - 4);
                    g.fillRect(this.getWidth() - this.lineNumber * this.getWidth() / this.allOfLineNumbers - 6, this.getHeight() - 8, 12, 8);
                } else {
                    g.drawLine(this.getWidth() - 4, 0, this.getWidth() - 4, this.getHeight());
                    g.fillRect(this.getWidth() - 8, this.lineNumber * this.getHeight() / this.allOfLineNumbers - 6, 8, 12);
                }
            }
            this.parseAndDrawFileContent(g);
            try {
                RecordStoreUtil.saveCurrentFileInfo(this.fileInfo);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void keyPressed(int keyCode) {
        if (this.doSettei) {
            return;
        }
        if (this.isTategaki) {
            switch (this.getGameAction(keyCode)) {
                case 5: {
                    this.processRightPressed(this.step);
                    this.doKeyPressed = true;
                    break;
                }
                case 2: {
                    this.processLeftPressed(this.step);
                    this.doKeyPressed = true;
                }
            }
        } else {
            switch (this.getGameAction(keyCode)) {
                case 1: {
                    this.processUpPressed(this.step);
                    this.doKeyPressed = true;
                    break;
                }
                case 6: {
                    this.processDownPressed(this.step);
                    this.doKeyPressed = true;
                }
            }
        }
        switch (keyCode) {
            case 55: {
                if (!this.fileInfo.hasPrev()) break;
                new Thread(){

                    public void run() {
                        try {
                            AozoraCanvas.this.setTicker(TICKER_FILE_YOMIKOMITYU);
                            int offset = (Integer)AozoraCanvas.this.fileInfo.getOffsetStack().pop();
                            AozoraCanvas.this.fileInfo = FileUtil.getFileContent(AozoraCanvas.this.fileInfo.getPath(), offset, AozoraCanvas.this.fileInfo.getOffsetStack());
                            AozoraCanvas.this.doPrev = true;
                            AozoraCanvas.this.setUpStrings();
                        }
                        catch (IOException e) {
                            Alert alert = new Alert("\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f", "\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f: " + e, null, null);
                            AozoraCanvas.this.display.setCurrent((Displayable)alert);
                        }
                    }
                }.start();
                break;
            }
            case 57: {
                if (!this.fileInfo.hasNext()) break;
                new Thread(){

                    public void run() {
                        try {
                            AozoraCanvas.this.setTicker(TICKER_FILE_YOMIKOMITYU);
                            AozoraCanvas.this.fileInfo.getOffsetStack().push(new Integer(AozoraCanvas.this.fileInfo.getOffset()));
                            AozoraCanvas.this.fileInfo = FileUtil.getFileContent(AozoraCanvas.this.fileInfo.getPath(), AozoraCanvas.this.fileInfo.getEnd() + 1, AozoraCanvas.this.fileInfo.getOffsetStack());
                            AozoraCanvas.this.doNext = true;
                            AozoraCanvas.this.setUpStrings();
                        }
                        catch (IOException e) {
                            Alert alert = new Alert("\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f", "\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f: " + e, null, null);
                            AozoraCanvas.this.display.setCurrent((Displayable)alert);
                        }
                    }
                }.start();
            }
        }
    }

    public void commandAction(Command command, Displayable arg1) {
        if (command == this.CMD_KIRIKAE) {
            this.setTicker(TICKER_YOKOTATE_KIRIKAETYU);
            this.doKirikae = true;
            this.isTategaki = !this.isTategaki;
            this.fileInfo.setTategaki(this.isTategaki);
            this.setUpStates();
        } else if (command == this.CMD_BACK) {
            this.display.setCurrent((Displayable)this.directoryList);
        } else if (command == this.CMD_SETTEI) {
            this.doSettei = true;
            this.display.setCurrent((Displayable)SettingsForm.getInstance((Displayable)this));
        } else if (command == this.CMD_SIORI_TUIKA) {
            this.doSettei = true;
            Bookmark bookmark = Bookmark.getInstance(this.fileInfo);
            BookmarkRegisterForm bookmarkRegisterForm = BookmarkRegisterForm.getInstance(bookmark, (Displayable)this);
            this.display.setCurrent((Displayable)bookmarkRegisterForm);
        } else if (command == this.CMD_SIORI_LIST) {
            this.doSettei = true;
            this.display.setCurrent((Displayable)BookmarksList.getInstance((Displayable)this));
        }
    }

    private void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
        if (lineNumber < 0) {
            this.lineNumber = 0;
        } else if (lineNumber > this.allOfLineNumbers) {
            this.lineNumber = this.allOfLineNumbers - 1;
        }
        this.zeroPoint = this.isTategaki ? this.initialZeroPoint + this.lineNumber * this.lineWidthOrHeight : this.initialZeroPoint - this.lineNumber * this.lineWidthOrHeight;
        this.fileInfo.setTategaki(this.isTategaki);
        this.fileInfo.setLineNumber(this.lineNumber);
    }

    private int getLineNumber() {
        return this.lineNumber;
    }

    private void processRightPressed(int step) {
        this.setLineNumber(this.getLineNumber() - step);
        this.repaint();
    }

    private void processLeftPressed(int step) {
        this.setLineNumber(this.getLineNumber() + step);
        this.repaint();
    }

    private void processUpPressed(int step) {
        this.setLineNumber(this.getLineNumber() - step);
        this.repaint();
    }

    private void processDownPressed(int step) {
        this.setLineNumber(this.getLineNumber() + step);
        this.repaint();
    }

    public void setFileInfo(FileInfo fileInfo) {
        this.fileInfo = fileInfo;
        System.err.println(fileInfo.getLineNumber());
        this.doSettei = true;
        this.setUpStrings();
    }

    public void run() {
        while (true) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.doKeyPressed || this.doSettei) {
                this.getKeyStates();
                this.doKeyPressed = false;
                continue;
            }
            int keyState = this.getKeyStates();
            if (this.isTategaki) {
                if ((keyState & 0x20) != 0) {
                    this.processRightPressed(this.fastStep);
                    continue;
                }
                if ((keyState & 4) == 0) continue;
                this.processLeftPressed(this.fastStep);
                continue;
            }
            if ((keyState & 2) != 0) {
                this.processUpPressed(this.fastStep);
                continue;
            }
            if ((keyState & 0x40) == 0) continue;
            this.processDownPressed(this.fastStep);
        }
    }

    public void finalizeSettei(boolean doKirikae) {
        this.doKirikae = doKirikae;
        this.doSettei = false;
        if (doKirikae) {
            this.fileInfo.setRubyTextSize(this.settings.getRubyTextSize());
            this.fileInfo.setPlainTextSize(this.settings.getPlainTextSize());
        }
        this.setUpStates();
    }

    public DirectoryList getDirectoryList() {
        return this.directoryList;
    }

    public void setDirectoryList(DirectoryList directoryList) {
        this.directoryList = directoryList;
    }
}

