/*
 *  mod_cdb.c
 *  version 0.1  *public domain*
 *
 *  by Yusuke Shinyama < yusuke at cs dot nyu dot edu >
 */

#include "httpd.h"
#include "http_config.h"
#include "http_core.h"
#include "http_log.h"
#include "http_main.h"
#include "http_protocol.h"
#include "http_request.h"
#include "util_script.h"
#include "http_connection.h"

#include "apr_strings.h"

#include <stdio.h>
#include <unistd.h>

#include "cdb.h"


/* module declaration */
module AP_MODULE_DECLARE_DATA cdb_module;


/* configuration */
typedef struct _cdb_dir_config {
    char *filename;
    char *mimetype;
} cdb_dir_config;

static void *create_cdb_dir_config(apr_pool_t *p, char* dummy)
{
    cdb_dir_config *conf = (cdb_dir_config *) apr_pcalloc(p, sizeof(cdb_dir_config));
    conf->filename = NULL;
    conf->mimetype = NULL;
    return (void*) conf;
}


/* handle a request */
static int get_cdb(request_rec *r)
{
    int retval = OK;
    server_rec *serv = r->server;
    cdb_dir_config *conf;

    if (strcmp(r->handler, "cdb"))
        return DECLINED;

    r->allowed |= (AP_METHOD_BIT << M_GET);
    if (r->method_number != M_GET) return DECLINED;

    conf = (cdb_dir_config *) ap_get_module_config(r->per_dir_config, &cdb_module);
    if (! (conf->filename && conf->mimetype) ) return DECLINED;

    {
	char* key = r->path_info + 1;
	struct cdb db;
	char buf[512];
	int fd;
	unsigned long dpos, dlen;

	/* open the cdb */
	fd = open(conf->filename, O_RDONLY);
	if (fd < 0) {
	    return HTTP_INTERNAL_SERVER_ERROR;
	}
	cdb_init(&db, fd);

	/* find it */
	cdb_findstart(&db);
	if (cdb_find(&db, key, strlen(key)) < 0) {
	    retval = HTTP_NOT_FOUND;
	    goto hell;
	}

	/* read */
	ap_set_content_type(r, conf->mimetype);
	dpos = cdb_datapos(&db);
	dlen = cdb_datalen(&db);
	while (0 < dlen) {
	    int n = (dlen < sizeof(buf))? dlen : sizeof(buf);
	    if (cdb_read(&db, buf, n, dpos) < 0) {
		retval = HTTP_NOT_FOUND;
		goto hell;
	    }
	    ap_rwrite(buf, n, r);
	    dpos += n;
	    dlen -= n;
	}
hell:
	/* cleanup */
	close(fd);
    }

    return retval;
}


/* declaratives */
static const char *set_cdb_source(cmd_parms *cmd, void *config, 
				  const char *filename, const char *mimetype)
{
    cdb_dir_config *conf = (cdb_dir_config*) config;

    conf->filename = apr_pstrdup(cmd->pool, filename);
    conf->mimetype = apr_pstrdup(cmd->pool, mimetype);
    return NULL;
}

static const command_rec cdb_cmds[] =
{
    AP_INIT_TAKE2("cdbsource", set_cdb_source, NULL, OR_FILEINFO,
		  "a cdb filename and its mimetype"),
    {NULL}
};


/* wrap up */
static void register_hooks(apr_pool_t *p)
{
    ap_hook_handler(get_cdb, NULL, NULL, APR_HOOK_MIDDLE);
}

module AP_MODULE_DECLARE_DATA cdb_module =
{
    STANDARD20_MODULE_STUFF,
    create_cdb_dir_config,	/* dir config creater */
    NULL,                       /* dir merger --- default is to override */
    NULL,			/* server config */
    NULL,			/* merge server config */
    cdb_cmds,			/* command apr_table_t */
    register_hooks,             /* set up other request processing hooks */
};
