#!/usr/bin/env python

# GTKYes-0.2 - by Yusuke Shinyama
# Requires: GTK+ 2.0 or newer, Python 2.2 or newer

import pygtk
pygtk.require("2.0")
import gtk
import gtk.glade
import locale, gettext

APPNAME = "gtkyes"

##  GTKYes
##
class GTKYes:

  INTERVAL = 5
  GLADEFILE = "gtkyes.glade"
  
  def __init__(self, yes_string="y"):
    self.wTree = gtk.glade.XML(self.GLADEFILE, "yeswindow", APPNAME)
    self.mainwindow = self.wTree.get_widget("yeswindow")
    dic = { "on_startbutton_clicked": self.do_start,
            "on_stopbutton_clicked": self.do_stop,
            "on_optionbutton_clicked": self.do_option,
            "on_clearbutton_clicked": self.do_clear,
            "on_quitbutton_clicked": self.quit,
            "on_yeswindow_destroy": self.quit,
            "on_start_activate": self.start_active,
            "on_stop_activate": self.stop_active,
            "on_option_activate": self.do_option,
            "on_clear_activate": self.do_clear,
            "on_quit_activate": self.quit,
            "on_about_activate": self.about,
            }
    self.wTree.signal_autoconnect(dic)
    self.yes_string = yes_string
    self.yes_timeout_id = None
    self.yes_scroll = self.wTree.get_widget("yesscrolledwindow").get_vadjustment()
    self.yes_text = self.wTree.get_widget("yestext")
    self.yes_buf = self.yes_text.get_buffer()
    self.statusbar = self.wTree.get_widget("statusbar1")
    self.status_context = self.statusbar.get_context_id("yes")
    self.show_status()
    return

  def show_status(self):
    self.statusbar.pop(self.status_context)
    if self.yes_timeout_id:
      self.statusbar.push(self.status_context, "Running...")
      self.wTree.get_widget("startbutton").set_sensitive(False)
      self.wTree.get_widget("stopbutton").set_sensitive(True)
    else:
      self.statusbar.push(self.status_context, "Stopped.")
      self.wTree.get_widget("startbutton").set_sensitive(True)
      self.wTree.get_widget("stopbutton").set_sensitive(False)
    return

  def do_option(self, widget):
    print "option"
    optiontree = gtk.glade.XML(self.GLADEFILE, "optiondialog", APPNAME)
    optiondialog = optiontree.get_widget("optiondialog")
    optiondialog.set_transient_for(self.mainwindow)
    optiontree.get_widget("yesentry").set_text(self.yes_string)
    result = optiondialog.run()
    if result == gtk.RESPONSE_OK:
      self.yes_string = optiontree.get_widget("yesentry").get_text().strip()
      print "set:", self.yes_string
    optiondialog.destroy()
    return
  
  def start_active(self, widget):
    if not self.yes_timeout_id:
      print "start"
      self.set_next_yes()
      self.show_status()
    return

  def stop_active(self, widget):
    if self.yes_timeout_id:
      print "stop"
      gtk.timeout_remove(self.yes_timeout_id)
      self.yes_timeout_id = None
      self.show_status()
    return

  def do_start(self, widget):
    self.wTree.get_widget("start").set_active(True)
    return
  def do_stop(self, widget):
    self.wTree.get_widget("stop").set_active(True)
    return

  def do_clear(self, widget):
    print "clear"
    self.statusbar.pop(self.status_context)
    self.statusbar.push(self.status_context, "Cleared.")
    self.yes_buf.set_text("")
    return

  def set_next_yes(self):
    self.yes_timeout_id = gtk.timeout_add(self.INTERVAL, self.do_yes)
    return

  def do_yes(self):
    self.yes_buf.insert(self.yes_buf.get_end_iter(), self.yes_string+"\n")
    self.yes_scroll.set_value(self.yes_scroll.upper)
    if self.yes_timeout_id:
      self.set_next_yes()
    return

  def about(self, widget):
    print "about"
    abouttree = gtk.glade.XML(self.GLADEFILE, "aboutdialog", APPNAME)
    aboutdialog = abouttree.get_widget("aboutdialog")
    aboutdialog.set_transient_for(self.mainwindow)
    result = aboutdialog.run()
    aboutdialog.destroy()
    return
  
  def quit(self, widget):
    print "quit"
    gtk.mainquit()
    return

  def main(self):
    gtk.mainloop()
    return

# main
if __name__ == "__main__":
  locale.setlocale(locale.LC_ALL, "")
  gtk.glade.bindtextdomain("gtkyes", "i18n")
  gtk.glade.textdomain("gtkyes")
  import dl
  l = dl.open ('/lib/libc.so.6')
  l.call ('bind_textdomain_codeset', "gtkyes", 'UTF-8');
  GTKYes().main()
