/*
 *  Stwmcmd - shell-based stwm controller
 *
 *  stwmcmd.h
 */


#ifndef _STWMCMD_H_
#define _STWMCMD_H_


/**  Constants
 **/

#define STWMCMD_VERSION		"0.2"

/*  Fixed buffer size
 */
#define	STWM_MAX_STRING		256
#define STWM_MAX_WINDOWS	256
#define STWM_BUFSIZ		(STWM_MAX_STRING * 16)

/*  STWM_DELIMITOR is used in the root window property to
 *  separate items.
 */
#define STWM_DELIMITOR		'\t'

/*  Command ID used between stwm and stwmcmd.
 */
enum {
    CMD_NONE = 0,
    CMD_QUERY,
    CMD_WARP,
    CMD_STACK,
    CMD_ZOOM,
    CMD_ICONIFY,
    CMD_CONFIGURE
};

/*  Result code used between stwm and stwmcmd.
 */
enum {
    STWM_RESULTCODE_OK		= 0,
    STWM_RESULTCODE_UNKNOWN	= -1,
    STWM_RESULTCODE_NOWINDOW	= -2,
    STWM_RESULTCODE_SYNTAX	= -100
};


/**  Types
 **/
typedef	char		stwmstr[STWM_MAX_STRING];

typedef	unsigned long	windowid;

/*  Stwm window specifier
 */
typedef	struct _wspec {
    windowid		id;
    stwmstr		full_name;
    stwmstr		title;
    stwmstr		icon_name;
    stwmstr		res_name;
    stwmstr		res_class;
    unsigned int	mapped, icon, auto_raise, highlight, zoomed;
    unsigned int	width, height;
    unsigned int	minwid, minhgt;
    unsigned int	maxwid, maxhgt;
    unsigned int	bwid, bhgt;
    unsigned int	widinc, hgtinc;
    unsigned int	x, y;
} wspec;

/*  Stwm command option specifier
 */
typedef struct _cspec {
    char		*name;
    int			cmd;
} cspec;

typedef int		(*funcptr)(wspec*, void*);


/**  Global variables
 **/
extern	char*		dpyname;
extern	int		stwm_windownum;
extern	windowid	stwm_windowid[];


/**  Function prototypes
 **/

/* from option.c */
extern	int		GetCommand(int argc, char* argv[], char*** cmdargv);
extern	int		MatchWindow(wspec* ws);

/* from xcomm.c */
extern	void		InitX(void);
extern	int		CheckEof(void);
extern	long		GetSigned(void);
extern	unsigned long	GetUnsigned(void);
extern	void		GetString(char* dest);
extern	void		GetWinInfo(wspec* ws);
extern	void		PutSigned(long val);
extern	void		PutUnsigned(unsigned long val);
extern	void		PutString(char* src);
extern	void		ResetSendBuff(void);
extern	void		ResetRecvBuff(void);
extern	int		GetWindowList(void);
extern	int		CommunicateStwm(void);

/* from cmd.c */
extern	void		usage(void);

#endif /* _STWMCMD_H_ */
