/*
 *  parseopt.h
 */

#ifndef _PARSEOPT_H_
#define _PARSEOPT_H_

#include <X11/Xlib.h>

#define MAXITEM 32

/* types */

typedef enum _wordstat {
    WORD_CR = -1,
    WORD_EOF = -2
} wordstat;

typedef enum _opttype {
    OPT_NULL = 0,
    OPT_BOOLEAN,		/* implicit */
    OPT_INT,
    OPT_STRING,
    OPT_LIST
} opttype;

typedef struct _optrec {
    char*   name;
    opttype type;
    void*   ptr;
} optrec;

/* WREC: */
struct _WREC;
typedef int (*getfunc)(struct _WREC*);
typedef void (*ungetfunc)(int, struct _WREC*);
typedef struct _WREC {
    void* fp;
    getfunc wrgetc;
    ungetfunc wrungetc;
    int quote;
    int separator;
    int crstop;
} WREC;

/* prototypes */
extern void	setwordstr(WREC* wr, char* s);
extern void	setwordopt(WREC* wr, int q, int s, int c);
extern void	setwordio(WREC* wr, getfunc gf, ungetfunc ugf, void* fp);
extern int	getword(WREC* wr, char* buff, int count);
extern int	nextline(WREC* wr);
extern int    	countitem(char** items);
extern char** 	addnitems(char** items, char* s);
extern char** 	removeitem(char** items, char* rmv);
extern char*  	getprogname(void);
extern void   	openlogfile(char* file);
extern void   	error(char* format, ...);
extern char*  	stritem(char** sp);
extern int    	parseopt(optrec* opts, int argc, char** argv, int replace);
extern void	usage();
extern void   	getXrsrc(Display* disp, optrec* rsrc);

#endif /* _PARSEOPT_H_ */
