/*
 *  Stwmcmd - option.c
 *
 *	Get command and options
 */


#include <stdio.h>
#include <stdlib.h>
#include <strings.h>

#include "stwmcmd.h"
#include "parseopt.h"

static	int		arg_full	= 0;
static	int		arg_sensitive	= 0;
static	int		arg_version	= 0;
static	char**		arg_id		= NULL;
static	char**		arg_title	= NULL;
static	char**		arg_class	= NULL;


/**  Static variables
 **/

/*  Option ident.
 */
static optrec stwm_opts[] = {
    { "d",		OPT_STRING,	&dpyname },
    { "disp",		OPT_STRING,	&dpyname },
    { "display",	OPT_STRING,	&dpyname },
    
    { "id",		OPT_LIST,	&arg_id },
    { "n",		OPT_LIST,	&arg_title },
    { "name",		OPT_LIST,	&arg_title },
    { "t",		OPT_LIST,	&arg_title },
    { "title",		OPT_LIST,	&arg_title },
    { "class",		OPT_LIST,	&arg_class },
    { "full",		OPT_BOOLEAN,	&arg_full },
    { "sensitive",	OPT_BOOLEAN,	&arg_sensitive },
    { "version",	OPT_BOOLEAN,	&arg_version },
    { NULL,		OPT_NULL,	NULL }
};


/*  Command ident.
 */
#define NUM_COMMANDS (sizeof(stwm_commands)/sizeof(cspec))

static cspec stwm_commands[] = {
    { "q",		CMD_QUERY },
    { "query",		CMD_QUERY },
    { "c",		CMD_CONFIGURE },
    { "configure",	CMD_CONFIGURE },
    { "s",		CMD_STACK },
    { "stack",		CMD_STACK },
    { "z",		CMD_ZOOM },
    { "zoom",		CMD_ZOOM },
    { "w",		CMD_WARP },
    { "warp",		CMD_WARP },
    { "i",		CMD_ICONIFY },
    { "iconify",	CMD_ICONIFY }
};


/**  Internal routines
 **/

/*  matchstr:  0: if ("s0" appears in "s1") 
 *             1: otherwise
 */
static int matchstr(char* s0, char* s1)	/* |s0| < |s1| */
{
    typedef int (*cmpfunc)(char*, char*, size_t);
    cmpfunc cmp;
    int ls0, ls1, i;
    ls0 = strlen(s0);
    ls1 = strlen(s1);
    if (ls1 < ls0)
	return(1);
    if (arg_full) {
	if (arg_sensitive)
	    return(strcmp(s0, s1));
	else
	    return(strcasecmp(s0, s1));
    }
    cmp = arg_sensitive? (cmpfunc)strncmp : (cmpfunc)strncasecmp;

    for(i = 0; i < (ls1-ls0+1); i++)
	if (!cmp(s0, s1+i, ls0))
	    return(0);
    return(1);
}


/*  matchstrlist:  0: if ("s" appears in the list)
 *                 1: otherwise
 */
static int matchstrlist(char* list[], char* s)
{
    while(*list)
	if (!matchstr(*list++, s))
	    return(0);
    return(1);
}


/*  matchnumlist:  0: if (n appears in the list)
 *                 1: otherwise
 */
static int matchnumlist(char* list[], unsigned long n)
{
    while(*list)
	if (strtoul(*list++, NULL, 10) == n)
	    return(0);
    return(1);
}


/**  Choosing specified windows
 **/

/*  MatchWindow:  0: if (wspec is matched for options)
 *                1: otherwise
 */
int MatchWindow(wspec* ws)
{
#ifdef DEBUG
    error("MatchWindow: arg_id=%lu, ws->id=%lu", arg_id, ws->id);
#endif

    if (arg_id && matchnumlist(arg_id, ws->id))
	return(1);

    if (arg_title && (matchstrlist(arg_title, ws->title) &&
		      matchstrlist(arg_title, ws->full_name) &&
		      matchstrlist(arg_title, ws->icon_name)))
	return(1);

    if (arg_class && (matchstrlist(arg_class, ws->res_name) &&
		      matchstrlist(arg_class, ws->res_class)))
	return(1);

    return(0);
}


/*  GetCommand: get command and options from shell args.
 */
int GetCommand(int argc, char* argv[], char*** cmdargv)
{
    int i, cmd = CMD_NONE;

    if ( !(argc = parseopt(stwm_opts, argc, argv, 1)) ) {
	if (arg_version) {
	    error("version: %s", STWMCMD_VERSION);
	    exit(0);
	}
	usage();
    }

    for(i = 0; i < NUM_COMMANDS; i++) {
	if (!strcasecmp(stwm_commands[i].name, argv[0])) {
	    cmd = stwm_commands[i].cmd;
	    break;
	}
    }
    if (cmd == CMD_NONE)
	usage();
    *cmdargv = &argv[1];

#ifdef DEBUG
    error("GetCommand: command=%d, args=%s", cmd, cmdarg);
#endif

    if (cmd != CMD_QUERY && !(arg_id || arg_title || arg_class)) {
	error("error: no window specifier.");
	exit(1);
    }

    return(cmd);
}
