.TH STWM 1 "December 1998"
.SH NAME
stwm, stwmcmd \- Shell-controllable Tab Window Manager
.SH SYNTAX
\fBstwm \fP[ \fB\-display\fP \fIdpy\fP ] [ \fB\-s\fP ]
[ \fB\-f\fP \fIinitfile\fP ] [ \fB\-v\fP ]

\fBstwmcmd \fP[ \fB\-display\fP \fIdpy\fP ]
[ \fIwindow specifiers\fP ] \fBcommand\fP [ \fIarguments\fP ]

\fBstwmwrapper \fP[title] args ...
.SH DESCRIPTION
\fIStwm\fP is an extension of Twm window manager.
Most of functions are equivalent to \fItwm\fP.
.PP
\fIStwmcmd\fP provide a shell-based interface which enables to
operate the specified windows. It communicates with \fIstwm\fP,
find the windows which is specified with \fIwindow specifiers\fP options,
and send a command to cause the operations.
.SH OPTIONS
.PP
.TP 8
.B \-display \fIdpy\fP
X display name.
.SH WINDOW SPECIFIERS
.TP 8
.B \-id \fP(or \-i) \fIwindowID1,windowID2, ...
Specify windows having any of window IDs.
.TP 8
.B \-title \fP(or \-t) \fItitle1,title2, ...
Specify windows having any of titles.
.TP 8
.B \-class \fP(or \-c) \fIclass1,class2, ...
Specify windows having any of classes.
.TP 8
.B \-full \fP(or \-f)
Make full string matching.
.TP 8
.B \-sensitive \fP(or \-s)
Make case sensitive matching.
.SH COMMANDS
.PP
.TP 0.5i
.B query \fP(or q) \fIfield1, field2, ...
Print the description of the specified window to standard output.
Each field name must be one of the following names. If no field name is
specified, print all of field values with its names. Otherwise,
print only field values specified by the field names.
.PP
.in +1.0i
id
.in +1.0i
window ID.
.PP
.in +1.0i
full_name
.in +1.0i
full name of the window.
.PP
.in +1.0i
title
.in +1.0i
window title.
.PP
.in +1.0i
icon_name
.in +1.0i
icon name.
.PP
.in +1.0i
resource_name
.in +1.0i
resource name.
.PP
.in +1.0i
resource_class
.in +1.0i
resource class.
.PP
.in +1.0i
mapped
.in +1.0i
1 if the window is mapped, 0 otherwise.
.PP
.in +1.0i
iconified
.in +1.0i
1 if the window is iconified, 0 otherwise.
.PP
.in +1.0i
auto_raise
.in +1.0i
1 if the window is auto-raised, 0 otherwise.
.PP
.in +1.0i
highlight
.in +1.0i
1 if the window is highlited, 0 otherwise.
.PP
.in +1.0i
zoomed
.in +1.0i
1 if the window is zoomed, 0 otherwise.
.PP
.in +1.0i
left
.in +1.0i
the X coordinates of the top-left corner of the window (in pixel)
.PP
.in +1.0i
top
.in +1.0i
the Y coordinates of the top-left corner of the window (in pixel)
.PP
.in +1.0i
width
.in +1.0i
the width of the window (in pixel)
.PP
.in +1.0i
height
.in +1.0i
the height of the window (in pixel)
.PP
.in +1.0i
base_width
.in +1.0i
the base width which is added to user-specified width.
.PP
.in +1.0i
base_height
.in +1.0i
the base height which is added to user-specified height.
.PP
.in +1.0i
inc_width
.in +1.0i
the increment width.
.PP
.in +1.0i
inc_height
.in +1.0i
the increment height.
.PP
.TP 0.5i
.B configure \fP(or c) \fIgeometry
Change the size or location of the specified window.
\fIGeometry\fP can be accepted in several forms:
.PP
.in +1.0i
"80x50+100-100" "400x200" "-0-0"
.in +1.0i
Standard geometry specification.  These forms specify the width,
the height, and the coordinates of the speficied window.
.PP
.in +1.0i
"x+100" "y-0"
.in +1.0i
These forms specify only x or y of the coordinates of the
specified window.
.PP
.in +1.0i
"h50" "w400"
.in +1.0i
These forms specify only the width or the height of the specified
window.
.PP
.in +1.0i
"X+100" "Y-40" "H-10" "W+1"
.in +1.0i
These forms increase/decrease the value with a value. The first
letter must be capitalized.
.TP 0.5i
.B stack \fP(or s)\fI [boolean]
Change the order of the window list.
Non-zero specifies to raise, zero to lower.
If the argument is omitted, toggle raize/lower.
.TP 0.5i
.B iconify \fP(or i)\fI [boolean]
Change the iconified state of the specified window.
Non-zero specifies to iconify, zero to deiconify.
If the argument is omitted, toggle iconify/deiconify.
.TP 0.5i
.B zoom \fP(or z)\fI [boolean]
Zoom the window.
Non-zero specifies to zoom, zero to unzoom(normalize).
If the argument is omitted, toggle zoom/unzoom.
.TP 0.5i
.B warp \fP(or w)
Warp the mouse pointer to the window.

.SH COMMAND ALIASES
\fIStwmwrapper\fP provides some brief aliases of the commands.
It executes \fIstwmcmd\fP inside.
.PP
.TP 0.5i
.BI "conf " "[title] geometry"
.TP 0.5i
.BI "move " "[title] geometry"
.TP 0.5i
.BI "resz " "[title] geometry"
Change the window size or location. If the title is omitted, 
the window which has the window ID specified by the
environment variable WINDOWID will be changed.
"conf xterm +0-0" is equivalent to "stwmcmd -name xterm configure +0-0".
"conf x+100" is equivalent to "stwmcmd -id $WINDOWID configure x+100".
.PP
.TP 0.5i
.BI "width " "[title] value"
.TP 0.5i
.BI "height " "[title] value"
Change the window width or height. If the title is omitted,
the window which has the window ID specified by the
environment variable WINDOWID will be changed.
.PP
.TP 0.5i
.BI "icon " "[title]"
Iconify or deiconify the window. If the title is omitted,
the window which has the window ID specified by the 
environment variable WINDOWID will be changed.
.PP
.TP 0.5i
.BI "warp " "[title]"
Warp the mouse pointer to the window.
.PP
.TP 0.5i
.BI "zoom " "[title]"
Zoom or unzoom the window.  If the title is omitted,
the window which has the window ID specified by the 
environment variable WINDOWID will be zoomed/unzoomed.
.PP
.TP 0.5i
.BI "raise " "[title]"
.TP 0.5i
.BI "lower " "[title]"
Raise or lower the window.  If the title is omitted,
the window which has the window ID specified by the 
environment variable WINDOWID will be raised/lowered.
.PP
.TP 0.5i
.BI "query " "[title field1 field2 ...]"
Display the description of the window. If the title is omitted,
the window which has the window ID specified by the 
environment variable WINDOWID will be inquired.
.SH BUGS
Please let me know.
.SH "SEE ALSO"
.PP
twm(1)
.SH AUTHOR
Yusuke SHINYAMA (\fBeuske@cs.titech.ac.jp\fP)
