#!/usr/bin/perl

do 'Include/common.pl';
do 'Include/refresh.pl';

chdir($VARDIR) || &bummer("Cannot chdir: $VARDIR: $!");

print "Content-Type: text/plain\n\n";

opendir(D, ".") || exit;
foreach my $f1 ( grep { /^w[0-9]+\.locked$/ } (readdir(D)) ) {
    my $f2 = $f1;
    $f2 =~ s/\.locked$//;
    rename($f1, $f2);
    print "$0: fix: $f1\n";
}
closedir(D);

opendir(D, ".") || exit;
foreach my $f1 ( grep { /^tmp\.[0-9]+$/ } (readdir(D)) ) {
    unlink($f1);
    print "$0: delete: $f1\n";
}
closedir(D);

&refresh_index();
print "$0: fixed.\n";
&msg("fixed");
