#!/usr/bin/env python
# -*- encoding: japanese.euc_jp -*-

import sys, sexpr
from abstfilter import AbstractFeeder, AbstractFilter, AbstractConsumer


##  CFormsReader
##
class CFormsReader(AbstractConsumer):

  def __init__(self, encin="japanese.euc_jp", encout="japanese.euc_jp"):
    AbstractConsumer.__init__(self)
    (self.encin, self.encout) = (encin, encout)
    self.cforms = {}
    return

  def feed(self, s):
    if len(s) != 2: raise "Illegal Syntax"
    k1 = unicode(s[0], self.encin)
    v1 = {}
    for x in s[1]:
      if x[1] == "*":
        (k, f1, f2) = (x[0], "", "")
      elif len(x) == 4:
        (k, f1, f2, dummy) = x
      elif len(x) == 3:
        (k, f1, f2) = x
      (k, f1, f2) = map(lambda x:unicode(x, self.encin), (k, f1, f2))
      if not v1.has_key(k):
        v1[k] = []
      v1[k].append((f1, f2))
    self.cforms[k1] = v1
    return

  def read(self, fname):
    self.fname = fname
    f = file(fname)
    p = sexpr.SExprReader(self)
    for line in f.xreadlines():
      p.feed(line)
    f.close()
    return self

  def export(self, header=1, out=sys.stdout):
    def enc(s):
      return 'u"%s"' % s.encode(self.encout)
    if header:
      out.write("#!/usr/bin/env python\n")
      out.write("# -*- encoding: %s -*-\n\n" % self.encout)
      out.write("# generated from %s\n\n" % self.fname)
      
    ktypes = self.cforms.keys()
    ktypes.sort()
    out.write("KFORM = {\n\n")
    for x in ktypes:
      v = self.cforms[x]
      kk = v.keys()
      kk.sort()
      out.write("  %s: {\n" % enc(x))
      for k in kk:
        out.write("    %s: [ %s ],\n" %
                  (enc(k), ", ".join(map(lambda (x,y):"(%s, %s)" % (enc(x),enc(y)), v[k]))))
      out.write("  },\n\n")
    out.write("}\n")
    out.flush()
    return self


# main
if __name__ == "__main__":
  if len(sys.argv) != 2:
    print >>sys.stderr, "usage: make_cforms.py cforms.cha"
    sys.exit(2)
  CFormsReader().read(sys.argv[1]).export()
