#!/usr/bin/env python
# -*- encoding: euc-jp -*-
import sys, re
sys.path.append('.')
stdout = sys.stdout
stderr = sys.stderr


# encode the yomigana.
def encode_yomi(s):
  def f(n):
    if (0x30a1 <= n and n <= 0x30f4) or n == 0x30fc:
      return chr(n-0x3000)
    raise ValueError(n)
  try:
    return chr(len(s))+''.join( f(ord(c)) for c in s )
  except ValueError:
    raise ValueError(s)

TRANS_TABLE = dict( (chr(ord(k)-0x3000), chr(ord(v)-0x3000)) for (k,v) in
  [
  (u'', u''),  #   
  (u'', u''),  #   
  #(u'', u''),  #   
  #(u'', u''),  #   
  ] )
CAN_TRANS = ''.join( TRANS_TABLE.get(chr(c),chr(c)) for c in xrange(256) )
def canonicalize_yomi(y):
  return y.translate(CAN_TRANS)


##  build_dict
##
def build_dict(output, files):
  import fileinput
  from fooling.pycdb import tcdbmake
  
  def e(s):
    return s.encode('utf-8')

  # find the length of the common prefix of s1 and s2.
  def common_prefix(s1, s2):
    s = zip(s1, s2)
    for (i,(c1,c2)) in enumerate(s):
      if c1 != c2: break
    else:
      i = len(s)
    return i

  maker = tcdbmake(output, output+'.tmp')
  w0 = ''
  stderr.write('Writing %r...' % output)
  stderr.flush()
  for line in fileinput.input(files):
    line = line.strip()
    if not line or line.startswith('#'): continue
    f = unicode(line, 'euc-jp').split(' ')
    w = f[0]
    n = common_prefix(w0, w)
    i = n+1
    #print w, xs
    for c in w[n:-1]:
      maker.put(i, e(c), '')
      i += 1
    v = ''.join( canonicalize_yomi(encode_yomi(y)) for y in f[1:] )
    maker.put(i, e(w[-1]), v)
    w0 = w
  maker.finish()
  stderr.write('finished.\n')
  return


# main
def main(argv):
  import getopt
  def usage():
    print 'usage: %s [-o output] [file ...]' % argv[0]
    return 100
  try:
    (opts, args) = getopt.getopt(argv[1:], 'o:')
  except getopt.GetoptError:
    return usage()
  output = 'yomidict.tcdb'
  for (k, v) in opts:
    if k == '-o': output = v
  return build_dict(output, args)

if __name__ == '__main__': sys.exit(main(sys.argv))
